/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.drill.utility;

import com.cognos.drill.utility.CognosJSONArray;
import com.cognos.drill.utility.xmlValidator;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class JSONToXMLConverter {
    private CognosJSONArray moJSONArray = new CognosJSONArray();
    String msRootNodeName = "";
    Document moDocument = DocumentHelper.createDocument();

    public JSONToXMLConverter(JSONObject oJSON, String sRootElementName) {
        this.moJSONArray.add(oJSON);
        this.setRootElementName(sRootElementName);
    }

    public JSONToXMLConverter(CognosJSONArray oJSONArray, String sRootElementName) {
        this.moJSONArray = oJSONArray;
        this.setRootElementName(sRootElementName);
    }

    public JSONToXMLConverter(String sJSON, String sRootElementName) {
        try {
            this.moJSONArray.add(sJSON);
            this.setRootElementName(sRootElementName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Document convert() throws Exception {
        this.moDocument.clearContent();
        Element root = this.getRootElement();
        this.convert(this.moJSONArray, root);
        return this.moDocument;
    }

    private void convert(JSONArray oJSONArray, Element root) throws Exception {
        Element newRoot = root;
        for (int iArrayIndex = 0; iArrayIndex < oJSONArray.size(); ++iArrayIndex) {
            JSONObject oJSON = (JSONObject)oJSONArray.get(iArrayIndex);
            this.convert(oJSON, newRoot);
        }
    }

    private void convert(Object o, Element root) throws Exception {
        if (o instanceof JSONObject) {
            JSONObject oJSON = (JSONObject)o;
            for (String sKey : oJSON.keySet()) {
                Object oValue;
                Element newNode = root;
                if (root == null) {
                    newNode = this.moDocument.addElement(sKey);
                }
                if ((oValue = oJSON.get((Object)sKey)) instanceof String) {
                    newNode = root.addElement(sKey);
                    String sValue = (String)oValue;
                    if (sValue.equals("")) continue;
                    newNode.addText(sValue);
                    continue;
                }
                if (oValue instanceof JSONArray) {
                    JSONArray oJSONArray = (JSONArray)oValue;
                    int len = oJSONArray.size();
                    for (int i = 0; i < len; ++i) {
                        newNode = sKey.length() == 0 ? root.addElement("array") : root.addElement(sKey);
                        this.convert(oJSONArray.get(i), newNode);
                    }
                    continue;
                }
                throw new Exception("Unknown JSON type: " + oValue.toString());
            }
        }
    }

    public String toString() {
        String sXML = "";
        try {
            sXML = this.convert().getRootElement().asXML();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return sXML;
    }

    private Element getRootElement() {
        Element root = this.moDocument.getRootElement();
        if (root == null && this.msRootNodeName.length() > 0) {
            root = this.moDocument.addElement(this.msRootNodeName);
        }
        return root;
    }

    public void setRootElementName(String sRootNodeName) {
        this.msRootNodeName = sRootNodeName;
    }

    public String validateXML() {
        try {
            String xmlString = this.toString();
            Element arrayElement = null;
            if (xmlString != null && xmlString.length() > 0) {
                xmlValidator val = new xmlValidator();
                if (val.init()) {
                    SAXReader saxReader = new SAXReader();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
                    Document document = saxReader.read((InputStream)byteArrayInputStream);
                    arrayElement = document.getRootElement();
                    this.validateElement(arrayElement, val);
                    val.validate();
                }
                return xmlString;
            }
        }
        catch (Exception exception) {
            return "<error><badParams> CAF Rejected</badParams></error>";
        }
        return "";
    }

    private void validateElement(Element ele, xmlValidator val) throws Exception {
        List eList = ele.elements();
        int listSize = eList.size();
        if (listSize > 0) {
            for (int index = 0; index < listSize; ++index) {
                Element eTag = (Element)eList.get(index);
                this.validateElement(eTag, val);
            }
        } else {
            String sName = ele.getName();
            String sValue = ele.getText();
            if (sValue != null) {
                try {
                    val.buildInputData(sName, sValue);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    throw exception;
                }
            }
        }
    }
}

