/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.drill.utility;

import com.cognos.drill.utility.C8FilterDOM;
import com.cognos.drill.utility.NBValue;
import com.cognos.drill.utility.NullValue;
import com.cognos.drill.utility.PeekableReader;
import com.cognos.drill.utility.RangeValue;
import com.cognos.drill.utility.SimpleValue;
import com.cognos.drill.utility.Value;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.Element;

public class PPFilterToC8FilterSpec {
    public static String convertPPFilterToC8FilterSpec(String filter) {
        return PPFilterToC8FilterSpec.CreateDOMFromFilter(filter, false);
    }

    public static String CreateDOMFromFilter(String s7Filter, boolean printError) {
        block3: {
            if (s7Filter != null && s7Filter.length() > 0) {
                PeekableReader reader = new PeekableReader(new StringReader(s7Filter), s7Filter.length());
                try {
                    C8FilterDOM c8FilterDOM = new C8FilterDOM();
                    Element esActions = c8FilterDOM.createRootNodes();
                    PPFilterToC8FilterSpec.createFilter(esActions, reader, c8FilterDOM);
                    return c8FilterDOM.writeXmlToString();
                }
                catch (Exception e) {
                    if (!printError) break block3;
                    System.out.println("Exception: " + e.getMessage());
                }
            }
        }
        return "";
    }

    private static void createFilter(Element parent, PeekableReader reader, C8FilterDOM c8FilterDOM) throws IOException {
        Element esExpression = c8FilterDOM.createRootExpression(parent);
        Element esOperatorOrNVPair = PPFilterToC8FilterSpec.createPredicateList(reader, c8FilterDOM);
        esExpression.appendChild(esOperatorOrNVPair);
    }

    private static Element createPredicateList(PeekableReader reader, C8FilterDOM c8FilterDOM) throws IOException {
        Element esPredicate1 = PPFilterToC8FilterSpec.createPredicate(reader, c8FilterDOM);
        int c = reader.skipSpacesAndPeek();
        if (c == 44) {
            Element eOperator = null;
            while (c == 44) {
                reader.skipSpacesAndRead();
                Element esPredicate2 = PPFilterToC8FilterSpec.createPredicate(reader, c8FilterDOM);
                eOperator = c8FilterDOM.createANDOperator(esPredicate1, esPredicate2);
                c = reader.skipSpacesAndPeek();
                esPredicate1 = eOperator;
            }
            return eOperator;
        }
        return esPredicate1;
    }

    private static Element createPredicate(PeekableReader reader, C8FilterDOM c8FilterDOM) throws IOException {
        Element eReturn = null;
        int c = reader.skipSpacesAndPeek();
        if (c == 91) {
            c = reader.skipSpacesAndRead();
            eReturn = PPFilterToC8FilterSpec.createANDConditionList(reader, c8FilterDOM);
            c = reader.skipSpacesAndRead();
            if (c != 93) {
                throw new IOException("Invalid Series 7 filter - Missing '['!");
            }
        }
        return eReturn;
    }

    private static Element createANDConditionList(PeekableReader reader, C8FilterDOM c8FilterDOM) throws IOException {
        Element eChild1 = PPFilterToC8FilterSpec.createANDCondition(reader, c8FilterDOM);
        int c = reader.skipSpacesAndPeek();
        if (c == 44) {
            Element eOperator = null;
            while (c == 44) {
                reader.skipSpacesAndRead();
                Element eChild2 = PPFilterToC8FilterSpec.createANDCondition(reader, c8FilterDOM);
                eOperator = c8FilterDOM.createANDOperator(eChild1, eChild2);
                c = reader.skipSpacesAndPeek();
                eChild1 = eOperator;
            }
            return eOperator;
        }
        return eChild1;
    }

    private static Element createANDCondition(PeekableReader reader, C8FilterDOM c8FilterDOM) throws IOException {
        Element eReturn = null;
        int c = reader.skipSpacesAndPeek();
        if (c == 93) {
            c = reader.skipSpacesAndRead();
        } else if (c != 91) {
            eReturn = PPFilterToC8FilterSpec.createNVPair(reader, c8FilterDOM);
        } else {
            c = reader.skipSpacesAndRead();
            eReturn = PPFilterToC8FilterSpec.createORConditionList(reader, c8FilterDOM);
            c = reader.skipSpacesAndRead();
            if (c != 93) {
                throw new IOException("Invalid Series 7 AND Condition - Missing ']'!");
            }
        }
        return eReturn;
    }

    private static Element createORConditionList(PeekableReader reader, C8FilterDOM c8FilterDOM) throws IOException {
        Element eReturn = null;
        Element eChild1 = PPFilterToC8FilterSpec.createORCondition(reader, c8FilterDOM);
        int c = reader.skipSpacesAndPeek();
        if (c == 44) {
            Element eOperator = null;
            while (c == 44) {
                reader.skipSpacesAndRead();
                Element eChild2 = PPFilterToC8FilterSpec.createORCondition(reader, c8FilterDOM);
                eOperator = c8FilterDOM.createOROperator(eChild1, eChild2);
                c = reader.skipSpacesAndPeek();
                eChild1 = eOperator;
            }
            eReturn = eOperator;
        } else {
            eReturn = eChild1;
        }
        return eReturn;
    }

    private static Element createORCondition(PeekableReader reader, C8FilterDOM c8FilterDOM) throws IOException {
        Element eReturn = null;
        int c = reader.skipSpacesAndPeek();
        if (c == 93) {
            c = reader.skipSpacesAndRead();
        } else if (c != 91) {
            eReturn = PPFilterToC8FilterSpec.createNVPair(reader, c8FilterDOM);
        } else {
            c = reader.skipSpacesAndRead();
            eReturn = PPFilterToC8FilterSpec.createANDConditionList(reader, c8FilterDOM);
            c = reader.skipSpacesAndRead();
            if (c != 93) {
                throw new IOException("Invalid Series 7 OR Condition - Missing ']'!");
            }
        }
        return eReturn;
    }

    private static Element createNVPair(PeekableReader reader, C8FilterDOM c8FilterDOM) throws IOException {
        String name = PPFilterToC8FilterSpec.createName(reader);
        if (name.length() == 0) {
            throw new IOException("Empty name encountered!");
        }
        int c = reader.skipSpacesAndRead();
        if (c != 61) {
            throw new IOException("Invalid Series 7 NVPair - Missing '='!");
        }
        Value value = PPFilterToC8FilterSpec.createValue(reader);
        Element eNameValuePair = c8FilterDOM.createNVPair(name, value);
        return eNameValuePair;
    }

    private static String createName(PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 34) {
            return PPFilterToC8FilterSpec.createText(reader);
        }
        return PPFilterToC8FilterSpec.createFunction(reader);
    }

    private static String createText(PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        if (c != 34) {
            throw new IOException("Invalid Series 7 Text - Not start with '\"'!");
        }
        String text = reader.getEnclosedText();
        c = reader.read();
        if (c != 34) {
            throw new IOException("Invalid Series 7 Text - Not end with '\"'!");
        }
        return text;
    }

    private static String createFunction(PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        while (c != 40) {
            c = reader.read();
            if (c != -1) continue;
            throw new IOException("Invalid Series 7 Function - Missing '('!");
        }
        String text = PPFilterToC8FilterSpec.createText(reader);
        c = reader.skipSpacesAndRead();
        if (c != 40) {
            throw new IOException("Invalid Series 7 Function - Missing '('!");
        }
        return text;
    }

    private static Value createValue(PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 40) {
            return PPFilterToC8FilterSpec.createRangeValue(reader);
        }
        if (c == 34) {
            return PPFilterToC8FilterSpec.createSimpleValue(reader);
        }
        c = reader.skipSpacesAndRead();
        if (c == 78) {
            c = reader.read();
            if (c == 66) {
                return new NBValue();
            }
            if (c == 85 && (c = reader.read()) == 76 && (c = reader.read()) == 76) {
                return new NullValue();
            }
        }
        throw new IOException("Invalid Series 7 Value - Neither NULL nor NB!");
    }

    private static Value createRangeValue(PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        if (c != 40) {
            throw new IOException("Invalid Series 7 Range Value - Should start with '('!");
        }
        String start = PPFilterToC8FilterSpec.createText(reader);
        c = reader.skipSpacesAndRead();
        if (c != 44) {
            throw new IOException("Invalid Series 7 List Separator - expected ','");
        }
        String end = PPFilterToC8FilterSpec.createText(reader);
        c = reader.skipSpacesAndRead();
        if (c != 41) {
            throw new IOException("Invalid Series 7 Range Value - Should end with ')'!");
        }
        return new RangeValue(start, end);
    }

    private static Value createSimpleValue(PeekableReader reader) throws IOException {
        String text = PPFilterToC8FilterSpec.createText(reader);
        return new SimpleValue(text);
    }

    public static void Test(String s7Filter, String sFilterFileSuffix, boolean bPrintError) throws IOException {
        String sResult = "";
        sResult = PPFilterToC8FilterSpec.CreateDOMFromFilter(s7Filter, bPrintError);
        FileWriter f = new FileWriter("PPFilterToC8FilterTest" + sFilterFileSuffix + ".xml");
        f.write(sResult);
        f.flush();
        f.write("<!-- Input: " + s7Filter + "-->");
        f.flush();
        f.close();
    }

    private static void runTests() throws IOException {
        PPFilterToC8FilterSpec.Test("[[\"Product Line\"=\"Outdoor Products\"]]", "_Test1", false);
        PPFilterToC8FilterSpec.Test("[[\"Product Line\"=\"OPP\"],[\"Product Type\"=\"Golf Equipment\"]]", "_Test2", false);
        PPFilterToC8FilterSpec.Test("[[\"nv1\"=\"1\",[\"nv2\"=\"2\",\"nv3\"=\"3\"]]]", "_Test3", false);
        PPFilterToC8FilterSpec.Test("[[\"nv1\"=\"1\"],[[\"nv2\"=\"2\",\"nv3\"=\"3\"]]]", "_Test3B", false);
        PPFilterToC8FilterSpec.Test("[[ [\"nv1\"=\"1\",\"nv2\"=\"2\"],[\"nv3\"=\"3\",\"nv4\"=\"4\"] ]]", "_Test4", false);
        PPFilterToC8FilterSpec.Test("[[[\"Pa\"=\"VA_1\",\"Pb\"=\"VB_1\"]]]", "_Test5", false);
        PPFilterToC8FilterSpec.Test("[[[\"Product Type\"=\"Cooking Equipment\",\"Product Line\"=\"Outdoor Products\"],[\"Product Type\"=\"Tents\",\"Product Line\"=\"Outdoor Products\"]]]", "_Test6", false);
        PPFilterToC8FilterSpec.Test("[[[ [\"P\"=\"1\",\"G\"=\"1\"],[\"P\"=\"2\",\"G\"=\"2\"] ]]]", "_Test7", false);
        PPFilterToC8FilterSpec.Test("[ [\"P\"=\"1\"],[\"G\"=\"2\"] ]", "_Test8", false);
        PPFilterToC8FilterSpec.Test("[ [\"P\"=\"1\"],[\"G\"=\"2\"],[\"H\"=\"3\"] ]", "_Test9", false);
        PPFilterToC8FilterSpec.Test("[ [\"P\"=\"1\",\"G\"=\"2\"] ]", "_Test10", false);
        PPFilterToC8FilterSpec.Test("[[ [\"P\"=\"1\",\"G\"=\"2\", \"H\"=\"3\"] ]]", "_Test11", false);
        PPFilterToC8FilterSpec.Test("[[ [\"P\"=\"1\", [\"G1\"=\"21\",\"G2\"=\"22\"], \"H\"=\"3\"] ]]", "_Test12", false);
        PPFilterToC8FilterSpec.Test("[[\"Order+Date\"=(\"2000-01-01\",\"2000-01-31\")],[[\"Product+Type\"=\"Cooking+Gear\",\"Product+Line\"=\"Camping+Equipment\"]]]", "_Test13", false);
        PPFilterToC8FilterSpec.Test("[[[\"Product+Type\"=NB,\"Product+Line\"=NULL]]]", "_Test14", false);
    }

    public static void main(String[] args) throws IOException {
        PPFilterToC8FilterSpec.runTests();
    }
}

