/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.drill.utility;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.validator.api.Document;
import com.cognos.validator.api.IParameter;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.xml.sax.SAXException;

public class xmlValidator {
    private HashMapParameter m_hmParameters = new HashMapParameter();
    private static final String VALIDATION_RESOURCE = "com/cognos/drill/utility/validation_rules.xml";
    private static final String VALIDATION_NAMESPACE = "urn:cognos:drill";
    private static ValidatorFactory m_factory = null;
    private static boolean m_bCafEnabled = false;

    private static void start() {
        try {
            m_factory = ValidatorFactory.newInstance();
            m_factory.put(0, true);
            ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
            cclConfig.init();
            xmlValidator.getCAFConfig(cclConfig);
        }
        catch (ValidatorException ve) {
            ve.printStackTrace();
            System.out.println("xmlValidator::init() - ValidatorFactory initialisation failed.");
        }
        catch (Exception ce) {
            System.out.println("xmlValidator::init() - CCLConfiguration initialization failed.");
        }
    }

    public void buildInputData(String id, String value) throws ParserConfigurationException, SAXException, IOException {
        this.m_hmParameters.put(id, value);
    }

    public IParameterUpdater getInputData() {
        return this.m_hmParameters;
    }

    public boolean init() {
        xmlValidator.start();
        return m_bCafEnabled;
    }

    private static void getCAFConfig(ICCLConfiguration cclConfig) {
        try {
            String sSection = "CAF";
            Element topCCL = cclConfig.getValueElement(sSection, false);
            if (topCCL == null) {
                System.out.println("xmlValidator::() - CAF Configuration could not be found");
                return;
            }
            String CRN_PARAMETER_TAG = "parameter";
            Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
            QName qnParameter = new QName(CRN_PARAMETER_TAG, nsCRN);
            List parameterElementList = topCCL.elements(qnParameter);
            int length = parameterElementList.size();
            for (int loop = 0; loop < length; ++loop) {
                Element valueNode;
                Element parameterNode = (Element)parameterElementList.get(loop);
                Attribute nameAttr = (Attribute)parameterNode.selectSingleNode("@name");
                if (!nameAttr.getValue().equals("caf_enabled") || !(valueNode = (Element)parameterNode.selectSingleNode("./crn:value")).getText().equals("true")) continue;
                m_bCafEnabled = true;
                return;
            }
        }
        catch (Exception e) {
            System.out.println("xmlValidator::getCAFConfig() - CAF settings could not be loaded");
        }
    }

    public boolean validate() throws Exception {
        IParameterUpdater input_data = this.getInputData();
        try {
            Document doc = m_factory.createDocument();
            if (!doc.loadFromNamespace(VALIDATION_NAMESPACE)) {
                ClassLoader cl = xmlValidator.class.getClassLoader();
                InputStream is = cl.getResourceAsStream(VALIDATION_RESOURCE);
                InputStreamReader isr = new InputStreamReader(is);
                doc.loadFromXML((Reader)isr);
            }
            VerifySession session = m_factory.createVerifySession(doc);
            session.verify(input_data);
            return true;
        }
        catch (VerifyException e) {
            System.out.println("\nxmlValidator::validate() - Verify Exception " + e.getMessage());
            throw new Exception("CAF: " + e.getLocalizedMessage());
        }
        catch (ValidatorException e) {
            System.out.println("\nxmlValidator::validate() - Validator Exception " + e.getMessage());
            throw new Exception("CAF: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
    }

    public class HashMapParameter
    implements IParameterUpdater {
        private Iterator m_iterator = null;
        private HashMap m_hashMap = new HashMap();

        public void put(String name, String value) {
            this.m_hashMap.put(name, value);
        }

        public boolean hasNext() {
            if (this.m_iterator == null) {
                this.m_iterator = this.m_hashMap.entrySet().iterator();
            }
            return this.m_iterator.hasNext();
        }

        public IParameter next() {
            Map.Entry entry = (Map.Entry)this.m_iterator.next();
            return new Parameter(entry);
        }

        public void reset() {
            this.m_iterator = null;
        }

        class Parameter
        implements IParameter {
            private String m_name = null;
            private String[] m_values = null;

            Parameter(Map.Entry entry) {
                this.m_name = (String)entry.getKey();
                this.m_values = new String[1];
                this.m_values[0] = (String)entry.getValue();
            }

            public String name() {
                return this.m_name;
            }

            public String[] values() {
                return this.m_values;
            }

            public void setValues(String[] arg0) {
            }
        }
    }
}

