/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.client;

import com.ibm.ba.flint.client.FlintClient;
import com.ibm.ba.flint.client.FlintClientPool;
import org.apache.thrift.TException;

public class BorrowedFlintClient
implements AutoCloseable {
    private final FlintClientPool pool;
    private FlintClient client;
    private boolean notReusable = false;

    public BorrowedFlintClient(FlintClientPool pool) throws TException {
        this.pool = pool;
        this.client = pool.borrowClient();
    }

    public void setNotReusable() {
        this.notReusable = true;
    }

    public FlintClient client() {
        if (null == this.client) {
            throw new IllegalStateException("client already returned to pool");
        }
        return this.client;
    }

    @Override
    public void close() {
        if (null != this.client) {
            this.pool.returnClient(this.client, this.notReusable);
            this.client = null;
        }
    }
}

