/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.client;

import com.ibm.ba.flint.client.ServiceDesc;
import com.ibm.ba.flint.client.Services;
import com.ibm.ba.flint.client.util.Slf4jMdcProvider;
import com.ibm.ba.flint.client.util.TContextualClientProtocol;
import com.ibm.ba.flint.client.util.ThreadLocalContextProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class FlintClient
implements AutoCloseable {
    private final TTransport transport;
    private final TProtocol protocol;
    private final Map<String, Object> serviceClientCache = new HashMap<String, Object>();
    private final long clientId;

    FlintClient(TTransport theTransport) throws TException {
        this.transport = theTransport;
        this.protocol = FlintClient.createProtocol(this.transport);
        this.clientId = this.fetchClientId();
    }

    FlintClient(TTransport theTransport, long theClientId) {
        this.transport = theTransport;
        this.protocol = FlintClient.createProtocol(this.transport);
        this.clientId = theClientId;
    }

    private static TProtocol createProtocol(TTransport transport) {
        TCompactProtocol baseProtocol = new TCompactProtocol(transport, 0x1000000L, 1000000L);
        TContextualClientProtocol contextProtocol = new TContextualClientProtocol((TProtocol)baseProtocol);
        contextProtocol.addProvider(new Slf4jMdcProvider());
        contextProtocol.addProvider(new ThreadLocalContextProvider());
        return contextProtocol;
    }

    private long fetchClientId() throws TException {
        return this.getService(Services.CORE_SERVICE).getClientId();
    }

    public boolean isOpen() {
        return this.transport.isOpen();
    }

    @Override
    public void close() {
        if (this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public long getClientId() {
        return this.clientId;
    }

    public <T, U extends TServiceClient> T getService(ServiceDesc<T, U> service) {
        Object serviceClient = this.serviceClientCache.computeIfAbsent(service.getName(), key -> service.getClientFactory().getClient((TProtocol)new TMultiplexedProtocol(this.protocol, key)));
        return service.getIface().cast(serviceClient);
    }
}

