/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.client;

import com.ibm.ba.flint.client.FlintClient;
import com.ibm.ba.flint.client.FlintClientFactory;
import com.ibm.ba.flint.client.PortProvider;
import com.ibm.ba.flint.thrift.util.TSocketHack;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlintClientBuilder {
    public static final int INFINITE_TIMEOUT = 0;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 58008;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlintClientBuilder.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 600000;
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    private String host = "localhost";
    private PortProvider portProvider = () -> 58008;
    private int connectTimeout = 60000;
    private int socketTimeout = 600000;
    private boolean sslEnabled = false;
    private String sslProtocol = "TLSv1.2";
    private String sslTrustStore = null;
    private String sslTrustStorePass = null;
    private String sslTrustStoreType = null;
    private String sslTrustManagerType = null;
    private String sslKeyStore = null;
    private String sslKeyStorePass = null;
    private String sslKeyStoreType = null;
    private String sslKeyManagerType = null;

    public FlintClientBuilder setHost(String theHost) {
        if (null == theHost || theHost.isEmpty()) {
            throw new IllegalArgumentException("host must be non-null and non-empty");
        }
        this.host = theHost;
        return this;
    }

    public FlintClientBuilder setPort(int thePort) {
        if (thePort < 1 || thePort > 65535) {
            throw new IllegalArgumentException("port must be > 0 and <= 65535");
        }
        this.portProvider = () -> thePort;
        return this;
    }

    public FlintClientBuilder setPortProvider(PortProvider thePortProvider) {
        if (null == thePortProvider) {
            throw new IllegalArgumentException("portProvider must be non-null");
        }
        this.portProvider = thePortProvider;
        return this;
    }

    public FlintClientBuilder setConnectTimeout(int theConnectTimeout) {
        if (theConnectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = theConnectTimeout;
        return this;
    }

    public FlintClientBuilder setSocketTimeout(int theSocketTimeout) {
        if (theSocketTimeout < 0) {
            throw new IllegalArgumentException("socketTimeout must be >= 0");
        }
        this.socketTimeout = theSocketTimeout;
        return this;
    }

    public FlintClientBuilder setSSLEnabled(boolean isEnabled) {
        this.sslEnabled = isEnabled;
        return this;
    }

    public FlintClientBuilder setSSLProtocol(String protocol) {
        this.sslProtocol = protocol;
        return this;
    }

    public FlintClientBuilder setSSLKeyStore(String keyStore, String keyPass, String keyManagerType, String keyStoreType) {
        this.sslKeyStore = keyStore;
        this.sslKeyStorePass = keyPass;
        this.sslKeyStoreType = keyStoreType;
        this.sslKeyManagerType = keyManagerType;
        return this;
    }

    public FlintClientBuilder setSSLTrustStore(String trustStore, String trustPass, String trustManagerType, String trustStoreType) {
        this.sslTrustStore = trustStore;
        this.sslTrustStorePass = trustPass;
        this.sslTrustStoreType = trustStoreType;
        this.sslTrustManagerType = trustManagerType;
        return this;
    }

    public FlintClient build() throws TTransportException {
        FlintClient client;
        TTransport transport = this.createTransport();
        try {
            client = new FlintClient(transport);
        }
        catch (TTransportException ex) {
            LOGGER.error("Failed to establish transport to server {}:{}", new Object[]{this.host, this.portProvider.getPort(), ex});
            if (transport.isOpen()) {
                transport.close();
            }
            throw ex;
        }
        catch (TException ex) {
            LOGGER.error("Failed to validate transport to server {}:{}", new Object[]{this.host, this.portProvider.getPort(), ex});
            if (transport.isOpen()) {
                transport.close();
            }
            throw new TTransportException("Failed to validate connection", (Throwable)ex);
        }
        return client;
    }

    public FlintClientFactory asFactory() {
        return this::build;
    }

    private TTransport createTransport() throws TTransportException {
        TSocket socket;
        int portNumber = this.portProvider.getPort();
        if (portNumber < 1) {
            throw new TTransportException("The port number could not be resolved.");
        }
        try {
            if (this.sslEnabled) {
                socket = TSSLTransportFactory.getClientSocket((String)this.host, (int)portNumber, (int)this.connectTimeout, (TSSLTransportFactory.TSSLTransportParameters)this.createSSLTransportParams());
                socket.setSocketTimeout(this.socketTimeout);
            } else {
                socket = new TSocket(this.host, portNumber, this.socketTimeout, this.connectTimeout);
                socket.open();
            }
            TSocketHack.resizeBuffers((TSocket)socket, (int)65536);
        }
        catch (TTransportException ex) {
            LOGGER.error("Failed to establish transport to server {}:{}", new Object[]{this.host, portNumber, ex});
            throw ex;
        }
        return socket;
    }

    private TSSLTransportFactory.TSSLTransportParameters createSSLTransportParams() {
        TSSLTransportFactory.TSSLTransportParameters sslParams = new TSSLTransportFactory.TSSLTransportParameters(this.sslProtocol, null);
        if (null != this.sslKeyStore && !this.sslKeyStore.isEmpty()) {
            sslParams.setKeyStore(this.sslKeyStore, this.sslKeyStorePass, this.sslKeyManagerType, this.sslKeyStoreType);
        }
        if (null != this.sslTrustStore && !this.sslTrustStore.isEmpty()) {
            sslParams.setTrustStore(this.sslTrustStore, this.sslTrustStorePass, this.sslTrustManagerType, this.sslTrustStoreType);
        }
        return sslParams;
    }
}

