/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.client.aop;

import com.ibm.ba.flint.client.aop.AfterAdvice;
import com.ibm.ba.flint.client.aop.BeforeAdvice;
import com.ibm.ba.flint.client.aop.MethodCallJoinPoint;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.mutable.MutableObject;

public class AdviceHandler
implements InvocationHandler {
    private final Object target;
    private BeforeAdvice before;
    private AfterAdvice after;

    public AdviceHandler(Object target) {
        this.target = target;
    }

    public AdviceHandler setBefore(BeforeAdvice before) {
        this.before = before;
        return this;
    }

    public AdviceHandler setAfter(AfterAdvice after) {
        this.after = after;
        return this;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodCallJoinPoint joinPoint = new MethodCallJoinPoint(method, this.target, args);
        MutableObject adviceContext = new MutableObject();
        if (null != this.before) {
            this.before.apply(joinPoint, (MutableObject<Object>)adviceContext);
        }
        Object returned = null;
        Throwable thrown = null;
        try {
            returned = method.invoke(this.target, args);
        }
        catch (InvocationTargetException ex) {
            thrown = ex.getTargetException();
        }
        if (null != this.after) {
            this.after.apply(joinPoint, returned, thrown, (MutableObject<Object>)adviceContext);
        }
        if (null != thrown) {
            throw thrown;
        }
        return returned;
    }
}

