/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.client.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolDecorator;

public class TContextualClientProtocol
extends TProtocolDecorator {
    private final List<ContextProvider> providers = new ArrayList<ContextProvider>();

    public TContextualClientProtocol(TProtocol protocol) {
        super(protocol);
    }

    public void addProvider(ContextProvider provider) {
        this.providers.add(provider);
    }

    public void removeProvider(ContextProvider provider) {
        this.providers.remove(provider);
    }

    public void writeMessageBegin(TMessage tMessage) throws TException {
        super.writeMessageBegin(tMessage);
        switch (tMessage.type) {
            case 1: 
            case 4: {
                this.writeContextMap();
                break;
            }
        }
    }

    private void writeContextMap() throws TException {
        Map<String, String> context = this.getContext();
        this.writeI32(context.size());
        for (Map.Entry<String, String> e : context.entrySet()) {
            this.writeString(e.getKey());
            this.writeString(e.getValue());
        }
    }

    private Map<String, String> getContext() {
        TreeMap<String, String> context = new TreeMap<String, String>();
        for (ContextProvider p : this.providers) {
            context.putAll(p.context());
        }
        return context;
    }

    @FunctionalInterface
    public static interface ContextProvider {
        public Map<String, String> context();
    }
}

