/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.avro;

import com.ibm.ba.flint.avro.AvroHelper;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.types.SchemaField;
import com.ibm.ba.flint.util.ReadableRow;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public class AvroReadableRow
implements ReadableRow {
    private final Schema schema;
    private final GenericRecord record;

    public AvroReadableRow(Schema schema, GenericRecord record) {
        if (null == schema) {
            throw new IllegalArgumentException("schema was null");
        }
        if (null == record) {
            throw new IllegalArgumentException("record was null");
        }
        this.schema = schema;
        this.record = record;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public GenericRecord getGenericRecord() {
        return this.record;
    }

    private Object valueAt(int index) {
        return this.record.get(index);
    }

    @Override
    public int size() {
        return this.schema.getFieldsSize();
    }

    @Override
    public boolean isNull(int index) {
        return null == this.valueAt(index);
    }

    @Override
    public Object get(int index) {
        return this.valueAt(index);
    }

    @Override
    public <T> T getAs(int index) {
        return (T)this.valueAt(index);
    }

    @Override
    public boolean getBoolean(int index) {
        return (Boolean)this.getAs(index);
    }

    @Override
    public ByteBuffer getBinary(int index) {
        return (ByteBuffer)this.getAs(index);
    }

    @Override
    public byte getByte(int index) {
        Integer value = (Integer)this.getAs(index);
        return (byte)(value & 0xFF);
    }

    @Override
    public Date getDate(int index) {
        return AvroHelper.decodeDate((GenericRecord)this.getAs(index));
    }

    @Override
    public BigDecimal getDecimal(int index) {
        SchemaField field = (SchemaField)this.schema.getFields().get(index);
        return AvroHelper.decodeDecimal((GenericFixed)this.getAs(index), field.getPrecision(), field.getScale());
    }

    @Override
    public double getDouble(int index) {
        return (Double)this.getAs(index);
    }

    @Override
    public float getFloat(int index) {
        return ((Float)this.getAs(index)).floatValue();
    }

    @Override
    public int getInt(int index) {
        return (Integer)this.getAs(index);
    }

    @Override
    public long getLong(int index) {
        return (Long)this.getAs(index);
    }

    @Override
    public short getShort(int index) {
        Integer value = (Integer)this.getAs(index);
        return (short)(value & 0xFFFF);
    }

    @Override
    public String getString(int index) {
        Utf8 value = (Utf8)this.getAs(index);
        return value.toString();
    }

    @Override
    public Timestamp getTimestamp(int index) {
        return AvroHelper.decodeTimestamp((GenericRecord)this.getAs(index));
    }

    public String toString() {
        return this.record.toString();
    }
}

