/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.avro;

import com.ibm.ba.flint.avro.AvroHelper;
import com.ibm.ba.flint.avro.AvroWritableRow;
import com.ibm.ba.flint.util.ArrayRowAccessor;
import com.ibm.ba.flint.util.ReadableRow;
import com.ibm.ba.flint.util.RowUtils;
import com.ibm.ba.flint.util.RowWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;

public class AvroRowWriter
implements RowWriter {
    private final com.ibm.ba.flint.thrift.types.Schema flintSchema;
    private final DataFileWriter<GenericRecord> writer;
    private final AvroWritableRow writableRow;
    private final RowUtils.RowTransfer rowCloner;
    private boolean closed = false;

    public AvroRowWriter(com.ibm.ba.flint.thrift.types.Schema schema, OutputStream out) throws IOException {
        Schema avroSchema = AvroHelper.toAvroSchema(schema);
        this.flintSchema = schema;
        this.writer = new DataFileWriter(GenericData.get().createDatumWriter(avroSchema)).setCodec(CodecFactory.snappyCodec()).create(avroSchema, out);
        this.writableRow = new AvroWritableRow(this.flintSchema, (GenericRecord)new GenericData.Record(avroSchema));
        this.rowCloner = RowUtils.createRowCloner(this.flintSchema);
    }

    @Override
    public void writeArray(Object[] source) throws IOException {
        if (source.length != this.flintSchema.getFieldsSize()) {
            throw new IllegalArgumentException("source.length != flintSchema.getFieldsSize()");
        }
        this.writeRow(new ArrayRowAccessor(source));
    }

    @Override
    public void writeRow(ReadableRow source) throws IOException {
        if (source.size() != this.flintSchema.getFieldsSize()) {
            throw new IllegalArgumentException("source.size() != flintSchema.getFieldsSize()");
        }
        this.expectNotClosed();
        this.rowCloner.apply(source, this.writableRow);
        this.writer.append((Object)this.writableRow.getGenericRecord());
    }

    @Override
    public void flush() throws IOException {
        this.expectNotClosed();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.writer.close();
        }
    }

    private void expectNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Writer closed");
        }
    }
}

