/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.avro;

import com.ibm.ba.flint.avro.AvroHelper;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.types.SchemaField;
import com.ibm.ba.flint.util.WritableRow;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.avro.generic.GenericRecord;

public class AvroWritableRow
implements WritableRow {
    private final Schema schema;
    private final GenericRecord record;

    public AvroWritableRow(Schema schema, GenericRecord record) {
        if (null == schema) {
            throw new IllegalArgumentException("schema was null");
        }
        if (null == record) {
            throw new IllegalArgumentException("record was null");
        }
        this.schema = schema;
        this.record = record;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public GenericRecord getGenericRecord() {
        return this.record;
    }

    @Override
    public int size() {
        return this.schema.getFieldsSize();
    }

    @Override
    public void setNull(int index) {
        this.record.put(index, null);
    }

    @Override
    public void set(int index, Object value) {
        if (null == value) {
            this.setNull(index);
        } else if (value instanceof Number) {
            if (value instanceof Double) {
                this.setDouble(index, (Double)value);
            } else if (value instanceof Long) {
                this.setLong(index, (Long)value);
            } else if (value instanceof Integer) {
                this.setInt(index, (Integer)value);
            } else if (value instanceof BigDecimal) {
                this.setDecimal(index, (BigDecimal)value);
            } else if (value instanceof Float) {
                this.setFloat(index, ((Float)value).floatValue());
            } else if (value instanceof Short) {
                this.setShort(index, (Short)value);
            } else if (value instanceof Byte) {
                this.setByte(index, (Byte)value);
            } else {
                this.setDouble(index, ((Number)value).doubleValue());
            }
        } else if (value instanceof String) {
            this.setString(index, (String)value);
        } else if (value instanceof Date) {
            this.setDate(index, (Date)value);
        } else if (value instanceof Timestamp) {
            this.setTimestamp(index, (Timestamp)value);
        } else if (value instanceof Boolean) {
            this.setBoolean(index, (Boolean)value);
        } else if (value instanceof byte[]) {
            this.setBinary(index, (byte[])value);
        } else if (value instanceof ByteBuffer) {
            this.setBinary(index, (ByteBuffer)value);
        } else {
            throw new IllegalArgumentException("Attempted to set unsupported value type (" + value.getClass().getName() + ") at index " + index);
        }
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.record.put(index, (Object)value);
    }

    @Override
    public void setBinary(int index, byte[] value) {
        this.record.put(index, (Object)ByteBuffer.wrap(value));
    }

    @Override
    public void setBinary(int index, ByteBuffer value) {
        this.record.put(index, (Object)value);
    }

    @Override
    public void setByte(int index, byte value) {
        this.record.put(index, (Object)value);
    }

    @Override
    public void setDate(int index, Date value) {
        this.record.put(index, (Object)AvroHelper.encodeDate(value));
    }

    @Override
    public void setDecimal(int index, BigDecimal value) {
        SchemaField field = (SchemaField)this.schema.getFields().get(index);
        this.record.put(index, (Object)AvroHelper.encodeDecimal(value, field.getPrecision(), field.getScale()));
    }

    @Override
    public void setDouble(int index, double value) {
        this.record.put(index, (Object)value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.record.put(index, (Object)Float.valueOf(value));
    }

    @Override
    public void setInt(int index, int value) {
        this.record.put(index, (Object)value);
    }

    @Override
    public void setLong(int index, long value) {
        this.record.put(index, (Object)value);
    }

    @Override
    public void setShort(int index, short value) {
        this.record.put(index, (Object)value);
    }

    @Override
    public void setString(int index, String value) {
        this.record.put(index, (Object)value);
    }

    @Override
    public void setTimestamp(int index, Timestamp value) {
        this.record.put(index, (Object)AvroHelper.encodeTimestamp(value));
    }

    public String toString() {
        return this.record.toString();
    }
}

