/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FSLinkResolver;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileStatusDefiler;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;

public class SecurityAgnosticRawLocalFileSystem
extends RawLocalFileSystem {
    private static void setDummyPermissions(FileStatus status) {
        FileStatusDefiler.setOwner(status, "nobody");
        FileStatusDefiler.setGroup(status, "nobody");
        if (status.isDirectory()) {
            FileStatusDefiler.setPermission(status, FsPermission.getDirDefault());
        } else {
            FileStatusDefiler.setPermission(status, FsPermission.getFileDefault());
        }
    }

    public void setPermission(Path p, FsPermission permission) {
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus status = super.getFileStatus(f);
        SecurityAgnosticRawLocalFileSystem.setDummyPermissions(status);
        return status;
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        FileStatus status = super.getFileStatus(f);
        if (status.isSymlink()) {
            Path targetQual = FSLinkResolver.qualifySymlinkTarget((URI)this.getUri(), (Path)status.getPath(), (Path)status.getSymlink());
            status.setSymlink(targetQual);
        }
        SecurityAgnosticRawLocalFileSystem.setDummyPermissions(status);
        return status;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        FileStatus[] list = super.listStatus(f);
        for (FileStatus fileStatus : super.listStatus(f)) {
            SecurityAgnosticRawLocalFileSystem.setDummyPermissions(fileStatus);
        }
        return list;
    }
}

