/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.io.buf;

import com.ibm.ba.flint.io.buf.ByteBufferAllocator;
import com.ibm.ba.flint.io.buf.ByteBufferPool;
import com.ibm.ba.flint.util.Bits;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class AbstractByteBufferPool
implements ByteBufferPool {
    private static final int DEFAULT_MIN_ALLOCATE_SIZE = 1024;
    private final ByteBufferAllocator allocator;
    private final int minAllocateSize;
    private final ByteBufferPool.SelectionPolicy selectionPolicy;

    AbstractByteBufferPool() {
        this(ByteBufferAllocator.HEAP, ByteBufferPool.SelectionPolicy.FIRST_FIT, 1024);
    }

    AbstractByteBufferPool(ByteBufferAllocator allocator, ByteBufferPool.SelectionPolicy selectionPolicy, int minAllocateSize) {
        Objects.requireNonNull(allocator, "allocator must not be null");
        Objects.requireNonNull(selectionPolicy, "selectionPolicy must not be null");
        if (minAllocateSize <= 0) {
            throw new IllegalArgumentException("minAllocateSize must be > 0");
        }
        this.allocator = allocator;
        this.selectionPolicy = selectionPolicy;
        this.minAllocateSize = minAllocateSize;
    }

    @Override
    public ByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        int adjustedCapacity = Bits.nextPow2(Math.max(this.minAllocateSize, capacity));
        ByteBuffer buf = this.findBuffer(adjustedCapacity);
        if (null == buf) {
            buf = this.allocator.allocate(adjustedCapacity);
        }
        buf.clear();
        return buf;
    }

    private ByteBuffer findBuffer(int capacity) {
        switch (this.selectionPolicy) {
            case FIRST_FIT: {
                return this.findBufferFirstFit(capacity);
            }
            case BEST_FIT: {
                return this.findBufferBestFit(capacity);
            }
        }
        throw new IllegalArgumentException("Unsupported selection policy: " + (Object)((Object)this.selectionPolicy));
    }

    protected abstract ByteBuffer findBufferFirstFit(int var1);

    protected abstract ByteBuffer findBufferBestFit(int var1);
}

