/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.io.buf;

import com.ibm.ba.flint.io.buf.ByteBufferPool;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;

public class ThreadLocalByteBufferPool
implements ByteBufferPool {
    private final ThreadLocal<ByteBufferPool> localPool;

    public ThreadLocalByteBufferPool(Supplier<ByteBufferPool> poolSupplier) {
        Objects.requireNonNull(poolSupplier, "poolSupplier must not be null");
        this.localPool = ThreadLocal.withInitial(poolSupplier);
    }

    @Override
    public ByteBuffer allocate(int capacity) {
        return this.localPool.get().allocate(capacity);
    }

    @Override
    public void release(ByteBuffer buf) {
        this.localPool.get().release(buf);
    }
}

