/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.thrift.util;

import com.ibm.ba.flint.thrift.types.Row;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.util.ThriftReadableRow;
import com.ibm.ba.flint.util.AbstractRowReader;
import com.ibm.ba.flint.util.ReadableRow;
import java.io.IOException;
import java.util.Iterator;

public class ThriftIterableRowReader
extends AbstractRowReader {
    private final Iterator<Row> iter;
    private final ThriftReadableRow readableRow;
    private boolean closed = false;

    public ThriftIterableRowReader(Schema schema, Iterable<Row> iterable) {
        super(schema);
        this.iter = iterable.iterator();
        this.readableRow = new ThriftReadableRow();
    }

    @Override
    public boolean hasMore() throws IOException {
        this.expectNotClosed();
        return this.iter.hasNext();
    }

    @Override
    public ReadableRow readRow() throws IOException {
        this.expectNotClosed();
        this.readableRow.setThriftRow(this.iter.next());
        return this.readableRow;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    private void expectNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Writer closed");
        }
    }
}

