/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.thrift.util;

import com.ibm.ba.flint.thrift.types.AnyValue;
import com.ibm.ba.flint.thrift.types.DateValue;
import com.ibm.ba.flint.thrift.types.DecimalValue;
import com.ibm.ba.flint.thrift.types.Row;
import com.ibm.ba.flint.thrift.types.TimestampValue;
import com.ibm.ba.flint.thrift.util.ThriftHelper;
import com.ibm.ba.flint.util.ReadableRow;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;

public class ThriftReadableRow
implements ReadableRow {
    private Row thriftRow;

    public ThriftReadableRow() {
        this.thriftRow = new Row();
    }

    public ThriftReadableRow(Row thriftRow) {
        if (null == thriftRow) {
            throw new IllegalArgumentException("thriftRow was null");
        }
        this.thriftRow = thriftRow;
    }

    private AnyValue valueAt(int index) {
        return (AnyValue)this.thriftRow.getValues().get(index);
    }

    public Row getThriftRow() {
        return this.thriftRow;
    }

    public void setThriftRow(Row thriftRow) {
        if (null == thriftRow) {
            throw new IllegalArgumentException("thriftRow was null");
        }
        this.thriftRow = thriftRow;
    }

    @Override
    public int size() {
        return this.thriftRow.getValuesSize();
    }

    @Override
    public boolean isNull(int index) {
        return this.valueAt(index).isSetNullValue();
    }

    @Override
    public Object get(int index) {
        AnyValue value = this.valueAt(index);
        if (value.isSetNullValue()) {
            return null;
        }
        if (value.isSetFloatValue()) {
            return Float.valueOf((float)value.getFloatValue());
        }
        if (value.isSetDateValue()) {
            return ThriftHelper.toSqlDate(value.getDateValue());
        }
        if (value.isSetTimestampValue()) {
            return ThriftHelper.toSqlTimestamp(value.getTimestampValue());
        }
        if (value.isSetDecimalValue()) {
            return ThriftHelper.toBigDecimal(value.getDecimalValue());
        }
        return value.getFieldValue();
    }

    @Override
    public <T> T getAs(int index) {
        return (T)this.get(index);
    }

    @Override
    public boolean getBoolean(int index) {
        return this.valueAt(index).getBooleanValue();
    }

    @Override
    public ByteBuffer getBinary(int index) {
        return this.valueAt(index).bufferForBinaryValue();
    }

    @Override
    public byte getByte(int index) {
        return this.valueAt(index).getByteValue();
    }

    @Override
    public Date getDate(int index) {
        DateValue dateValue = this.valueAt(index).getDateValue();
        return ThriftHelper.toSqlDate(dateValue);
    }

    @Override
    public BigDecimal getDecimal(int index) {
        DecimalValue decimalValue = this.valueAt(index).getDecimalValue();
        return ThriftHelper.toBigDecimal(decimalValue);
    }

    @Override
    public double getDouble(int index) {
        return this.valueAt(index).getDoubleValue();
    }

    @Override
    public float getFloat(int index) {
        return (float)this.valueAt(index).getFloatValue();
    }

    @Override
    public int getInt(int index) {
        return this.valueAt(index).getIntValue();
    }

    @Override
    public long getLong(int index) {
        return this.valueAt(index).getLongValue();
    }

    @Override
    public short getShort(int index) {
        return this.valueAt(index).getShortValue();
    }

    @Override
    public String getString(int index) {
        return this.valueAt(index).getStringValue();
    }

    @Override
    public Timestamp getTimestamp(int index) {
        TimestampValue timestampValue = this.valueAt(index).getTimestampValue();
        return ThriftHelper.toSqlTimestamp(timestampValue);
    }

    public String toString() {
        return this.thriftRow.toString();
    }
}

