/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.thrift.util;

import com.ibm.ba.flint.thrift.types.AnyValue;
import com.ibm.ba.flint.thrift.types.Row;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.types.SchemaField;
import com.ibm.ba.flint.thrift.util.ThriftHelper;
import com.ibm.ba.flint.util.WritableRow;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;

public class ThriftWritableRow
implements WritableRow {
    private final Schema schema;
    private Row thriftRow;

    public ThriftWritableRow(Schema schema) {
        if (null == schema) {
            throw new IllegalArgumentException("schema was null");
        }
        this.schema = schema;
        this.thriftRow = new Row();
        for (int i = 0; i < schema.getFieldsSize(); ++i) {
            this.thriftRow.addToValues(AnyValue.nullValue((boolean)true));
        }
    }

    public ThriftWritableRow(Schema schema, Row thriftRow) {
        if (null == schema) {
            throw new IllegalArgumentException("schema was null");
        }
        if (null == thriftRow) {
            throw new IllegalArgumentException("thriftRow was null");
        }
        this.schema = schema;
        this.thriftRow = thriftRow;
    }

    private AnyValue valueAt(int index) {
        return (AnyValue)this.thriftRow.getValues().get(index);
    }

    public Row getThriftRow() {
        return this.thriftRow;
    }

    public void setThriftRow(Row thriftRow) {
        if (null == thriftRow) {
            throw new IllegalArgumentException("thriftRow was null");
        }
        this.thriftRow = thriftRow;
    }

    public void resizeThriftRow() {
        block3: {
            int sizeDelta;
            block2: {
                int rowSize = this.thriftRow.getValuesSize();
                sizeDelta = rowSize - this.schema.getFieldsSize();
                if (sizeDelta <= 0) break block2;
                while (sizeDelta > 0) {
                    this.thriftRow.getValues().remove(rowSize - 1);
                    --sizeDelta;
                    --rowSize;
                }
                break block3;
            }
            if (sizeDelta >= 0) break block3;
            while (sizeDelta < 0) {
                this.thriftRow.addToValues(AnyValue.nullValue((boolean)true));
                ++sizeDelta;
            }
        }
    }

    @Override
    public int size() {
        return this.thriftRow.getValuesSize();
    }

    @Override
    public void setNull(int index) {
        this.valueAt(index).setNullValue(true);
    }

    @Override
    public void set(int index, Object value) {
        if (null == value) {
            this.setNull(index);
        } else if (value instanceof Number) {
            if (value instanceof Double) {
                this.setDouble(index, (Double)value);
            } else if (value instanceof Long) {
                this.setLong(index, (Long)value);
            } else if (value instanceof Integer) {
                this.setInt(index, (Integer)value);
            } else if (value instanceof BigDecimal) {
                this.setDecimal(index, (BigDecimal)value);
            } else if (value instanceof Float) {
                this.setFloat(index, ((Float)value).floatValue());
            } else if (value instanceof Short) {
                this.setShort(index, (Short)value);
            } else if (value instanceof Byte) {
                this.setByte(index, (Byte)value);
            } else {
                this.setDouble(index, ((Number)value).doubleValue());
            }
        } else if (value instanceof String) {
            this.setString(index, (String)value);
        } else if (value instanceof Date) {
            this.setDate(index, (Date)value);
        } else if (value instanceof Timestamp) {
            this.setTimestamp(index, (Timestamp)value);
        } else if (value instanceof Boolean) {
            this.setBoolean(index, (Boolean)value);
        } else if (value instanceof byte[]) {
            this.setBinary(index, (byte[])value);
        } else if (value instanceof ByteBuffer) {
            this.setBinary(index, (ByteBuffer)value);
        } else {
            throw new IllegalArgumentException("Attempted to set unsupported value type (" + value.getClass().getName() + ") at index " + index);
        }
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.valueAt(index).setBooleanValue(value);
    }

    @Override
    public void setBinary(int index, byte[] value) {
        this.valueAt(index).setBinaryValue(value);
    }

    @Override
    public void setBinary(int index, ByteBuffer value) {
        this.valueAt(index).setBinaryValue(value);
    }

    @Override
    public void setByte(int index, byte value) {
        this.valueAt(index).setByteValue(value);
    }

    @Override
    public void setDate(int index, Date value) {
        this.valueAt(index).setDateValue(ThriftHelper.toDateValue(value));
    }

    @Override
    public void setDecimal(int index, BigDecimal value) {
        SchemaField field = (SchemaField)this.schema.getFields().get(index);
        this.valueAt(index).setDecimalValue(ThriftHelper.toDecimalValue(value, field.getPrecision(), field.getScale()));
    }

    @Override
    public void setDouble(int index, double value) {
        this.valueAt(index).setDoubleValue(value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.valueAt(index).setFloatValue((double)value);
    }

    @Override
    public void setInt(int index, int value) {
        this.valueAt(index).setIntValue(value);
    }

    @Override
    public void setLong(int index, long value) {
        this.valueAt(index).setLongValue(value);
    }

    @Override
    public void setShort(int index, short value) {
        this.valueAt(index).setShortValue(value);
    }

    @Override
    public void setString(int index, String value) {
        this.valueAt(index).setStringValue(value);
    }

    @Override
    public void setTimestamp(int index, Timestamp value) {
        this.valueAt(index).setTimestampValue(ThriftHelper.toTimestampValue(value));
    }

    public String toString() {
        return this.thriftRow.toString();
    }
}

