/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import com.ibm.ba.flint.util.ReadableRow;
import com.ibm.ba.flint.util.WritableRow;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;

public class ArrayRowAccessor
implements ReadableRow,
WritableRow {
    private final Object[] array;

    public ArrayRowAccessor(Object ... array) {
        if (null == array) {
            throw new NullPointerException("array was null");
        }
        this.array = array;
    }

    public Object[] getArray() {
        return this.array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isNull(int index) {
        return this.array[index] == null;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public <T> T getAs(int index) {
        return (T)this.array[index];
    }

    @Override
    public boolean getBoolean(int index) {
        return (Boolean)this.getAs(index);
    }

    @Override
    public ByteBuffer getBinary(int index) {
        if (this.array[index] instanceof byte[]) {
            return ByteBuffer.wrap((byte[])this.array[index]);
        }
        return (ByteBuffer)this.array[index];
    }

    @Override
    public byte getByte(int index) {
        return (Byte)this.getAs(index);
    }

    @Override
    public Date getDate(int index) {
        return (Date)this.getAs(index);
    }

    @Override
    public BigDecimal getDecimal(int index) {
        return (BigDecimal)this.getAs(index);
    }

    @Override
    public double getDouble(int index) {
        return (Double)this.getAs(index);
    }

    @Override
    public float getFloat(int index) {
        return ((Float)this.getAs(index)).floatValue();
    }

    @Override
    public int getInt(int index) {
        return (Integer)this.getAs(index);
    }

    @Override
    public long getLong(int index) {
        return (Long)this.getAs(index);
    }

    @Override
    public short getShort(int index) {
        return (Short)this.getAs(index);
    }

    @Override
    public String getString(int index) {
        return (String)this.getAs(index);
    }

    @Override
    public Timestamp getTimestamp(int index) {
        return (Timestamp)this.getAs(index);
    }

    @Override
    public void setNull(int index) {
        this.array[index] = null;
    }

    @Override
    public void set(int index, Object value) {
        this.array[index] = value;
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.set(index, value);
    }

    @Override
    public void setBinary(int index, byte[] value) {
        this.set(index, value);
    }

    @Override
    public void setBinary(int index, ByteBuffer value) {
        this.set(index, value);
    }

    @Override
    public void setByte(int index, byte value) {
        this.set(index, value);
    }

    @Override
    public void setDate(int index, Date value) {
        this.set(index, value);
    }

    @Override
    public void setDecimal(int index, BigDecimal value) {
        this.set(index, value);
    }

    @Override
    public void setDouble(int index, double value) {
        this.set(index, value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.set(index, Float.valueOf(value));
    }

    @Override
    public void setInt(int index, int value) {
        this.set(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.set(index, value);
    }

    @Override
    public void setShort(int index, short value) {
        this.set(index, value);
    }

    @Override
    public void setString(int index, String value) {
        this.set(index, value);
    }

    @Override
    public void setTimestamp(int index, Timestamp value) {
        this.set(index, value);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

