/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class AutoTryLock
implements AutoCloseable {
    private final Lock lock;
    private boolean acquired;

    public AutoTryLock(Lock theLock) {
        this.lock = theLock;
        this.acquired = this.lock.tryLock();
    }

    public AutoTryLock(Lock theLock, long timeout, TimeUnit unit) throws InterruptedException {
        this.lock = theLock;
        try {
            this.acquired = this.lock.tryLock(timeout, unit);
        }
        catch (InterruptedException ex) {
            this.acquired = false;
            throw ex;
        }
    }

    public boolean wasAcquired() {
        return this.acquired;
    }

    @Override
    public void close() {
        if (this.acquired) {
            this.lock.unlock();
        }
    }
}

