/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;

public class DecimalUtil {
    private DecimalUtil() {
    }

    public static BigDecimal adjustDecimalForPrecisionAndScale(BigDecimal decimal, int precision, int scale) {
        if (precision < decimal.precision()) {
            throw new IllegalArgumentException("precision < decimal.precision()");
        }
        BigDecimal adjustedDecimal = decimal.scale() == scale ? decimal : decimal.setScale(scale, RoundingMode.UNNECESSARY);
        if (adjustedDecimal.precision() > precision) {
            throw new IllegalArgumentException(String.format("The decimal value (%s) cannot be stored with the desired precision (%d) and scale (%d)", decimal.toString(), precision, scale));
        }
        return adjustedDecimal;
    }

    public static int decimalPrecisionToByteLength(int precision) {
        if (precision <= 9) {
            return 4;
        }
        if (precision <= 18) {
            return 8;
        }
        return 16;
    }

    public static void decimalToUnscaledBytes(BigDecimal decimal, int precision, byte[] outBuf) {
        int numBytes = DecimalUtil.decimalPrecisionToByteLength(precision);
        if (numBytes != outBuf.length) {
            throw new IllegalArgumentException(String.format("Output buffer length (%d) does not match expected length (%d) for decimal precision (%d)", outBuf.length, numBytes, precision));
        }
        byte[] unscaledBytes = decimal.unscaledValue().toByteArray();
        byte signByte = unscaledBytes[0] < 0 ? (byte)-1 : 0;
        Arrays.fill(outBuf, 0, numBytes - unscaledBytes.length, signByte);
        System.arraycopy(unscaledBytes, 0, outBuf, numBytes - unscaledBytes.length, unscaledBytes.length);
    }
}

