/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util;

import com.ibm.ba.flint.util.RefCounted;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class RefCountSupport
implements RefCounted {
    private final AtomicInteger refCount;

    public RefCountSupport() {
        this(0);
    }

    public RefCountSupport(int initialRefCount) {
        if (initialRefCount < 0) {
            throw new IllegalArgumentException("initialRefCount must be non-negative");
        }
        this.refCount = new AtomicInteger(initialRefCount);
    }

    @Override
    public int getRefCount() {
        return this.refCount.get();
    }

    @Override
    public int decrementRefCount() {
        int count;
        do {
            if ((count = this.refCount.get()) != 0) continue;
            throw new IllegalStateException("refCount must be non-negative");
        } while (!this.refCount.compareAndSet(count, count - 1));
        return count - 1;
    }

    @Override
    public int incrementRefCount() {
        return this.refCount.incrementAndGet();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("refCount", this.getRefCount()).toString();
    }
}

