/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.util.xfun;

import com.ibm.ba.flint.util.xfun.XFunction0;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class XLazy<V, E extends Throwable> {
    private static final int STATE_UNSET = 0;
    private static final int STATE_INIT_STARTED = 1;
    private static final int STATE_INIT_SUCCESS = 2;
    private static final int STATE_INIT_FAILED = 3;
    private final XFunction0<V, E> supplier;
    private final AtomicInteger state = new AtomicInteger(0);
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile V value;
    private volatile Throwable error;

    public XLazy(XFunction0<V, E> supplier) {
        Objects.requireNonNull(supplier, "supplier must not be null");
        this.supplier = supplier;
    }

    public boolean isUnset() {
        return this.state.get() == 0;
    }

    public boolean isInitializing() {
        return this.state.get() == 1;
    }

    public boolean isSet() {
        return this.state.get() == 2;
    }

    public boolean hasError() {
        return this.state.get() == 3;
    }

    public V get() throws InterruptedException, E {
        int currentState;
        block11: while (true) {
            currentState = this.state.get();
            switch (currentState) {
                case 0: {
                    if (!this.state.compareAndSet(0, 1)) continue block11;
                    try {
                        this.value = this.supplier.call();
                        this.state.set(2);
                        continue block11;
                    }
                    catch (Throwable ex) {
                        this.error = ex;
                        this.state.set(3);
                        continue block11;
                    }
                    finally {
                        this.latch.countDown();
                        continue block11;
                    }
                }
                case 1: {
                    this.latch.await();
                    continue block11;
                }
                case 2: {
                    return this.value;
                }
                case 3: {
                    throw this.error;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected state: " + currentState);
    }
}

