/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.launcher;

import com.ibm.ba.flint.client.BorrowedFlintClient;
import com.ibm.ba.flint.client.FlintClientPool;

public class HealthMonitor
extends Thread {
    private final FlintClientPool clientPool;
    private final int checkIntervalMillis;
    private boolean lastStatus = false;
    private volatile HealthListener healthListener = null;
    private volatile boolean closed = false;

    public HealthMonitor(FlintClientPool clientPool, int checkIntervalMillis) {
        if (null == clientPool) {
            throw new NullPointerException("clientPool was null");
        }
        if (checkIntervalMillis < 1) {
            throw new IllegalArgumentException("checkIntervalMillis < 1");
        }
        this.clientPool = clientPool;
        this.checkIntervalMillis = checkIntervalMillis;
        this.setDaemon(true);
        this.setName("Flint.Launcher.HealthMonitor");
    }

    public HealthMonitor setHealthListener(HealthListener listener) {
        this.healthListener = listener;
        return this;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                Thread.sleep(this.checkIntervalMillis);
            }
            catch (InterruptedException ex) {
                continue;
            }
            if (this.checkHealth()) {
                if (this.lastStatus) continue;
                this.lastStatus = true;
                this.fireOnStatusChanged(true);
                continue;
            }
            if (!this.lastStatus) continue;
            this.lastStatus = false;
            this.fireOnStatusChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkHealth() {
        try (BorrowedFlintClient borrowed = new BorrowedFlintClient(this.clientPool);){
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void fireOnStatusChanged(boolean up) {
        HealthListener listener = this.healthListener;
        if (null != listener) {
            listener.onStatusChanged(up);
        }
    }

    @FunctionalInterface
    public static interface HealthListener {
        public void onStatusChanged(boolean var1);
    }
}

