/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.launcher;

import java.io.IOException;
import java.io.InputStream;

public class ProcessMonitor
extends Thread {
    private final Process process;
    private TerminationListener terminationListener;
    private InputConsumer inputConsumer = ProcessMonitor::defaultInputConsumer;

    public ProcessMonitor(Process theProcess) {
        this.process = theProcess;
        this.setDaemon(true);
        this.setName("Flint.Launcher.ProcessMonitor");
    }

    private static void defaultInputConsumer(InputStream in) {
        byte[] buf = new byte[4096];
        try {
            while (in.read(buf) != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ProcessMonitor setTerminationListener(TerminationListener listener) {
        this.terminationListener = listener;
        return this;
    }

    public ProcessMonitor setInputConsumer(InputConsumer consumer) {
        if (null == consumer) {
            throw new NullPointerException("consumer was null");
        }
        this.inputConsumer = consumer;
        return this;
    }

    @Override
    public void run() {
        while (this.process.isAlive()) {
            this.inputConsumer.consume(this.process.getInputStream());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fireOnTerminate(this.process.exitValue());
    }

    private void fireOnTerminate(int exitValue) {
        TerminationListener listener = this.terminationListener;
        if (null != listener) {
            listener.onTerminated(exitValue);
        }
    }

    @FunctionalInterface
    public static interface InputConsumer {
        public void consume(InputStream var1);
    }

    @FunctionalInterface
    public static interface TerminationListener {
        public void onTerminated(int var1);
    }
}

