/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.launcher.logging;

import com.ibm.ba.flint.launcher.logging.JsonEventReceiver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEventSocketServer
extends JsonEventReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonEventSocketServer.class);
    private final ServerSocket serverSock;

    public JsonEventSocketServer(int port, InetAddress ifAddress) throws IOException {
        this(new DefaultServerSocketFactory(), port, ifAddress);
    }

    public JsonEventSocketServer(ServerSocketFactory factory, int port, InetAddress ifAddress) throws IOException {
        this.serverSock = factory.createServerSocket(port, 2, ifAddress);
        this.serverSock.setSoTimeout(1000);
    }

    public int getLocalPort() {
        return this.serverSock.getLocalPort();
    }

    @Override
    protected void onStarted() {
        LOGGER.info("Started JsonEventSocketServer at local address [{}]", (Object)this.serverSock.getLocalSocketAddress());
    }

    @Override
    protected void onStopped() {
        LOGGER.info("Stopped JsonEventSocketServer");
    }

    @Override
    protected void onClosed() {
        try {
            this.serverSock.close();
        }
        catch (IOException ex) {
            LOGGER.error("Unexpected error while closing ServerSocket", (Throwable)ex);
        }
        LOGGER.info("Closed JsonEventSocketServer");
    }

    @Override
    protected void doRun() {
        while (this.isRunning()) {
            try {
                Socket clientSock = this.serverSock.accept();
                LOGGER.info("Client accepted: {}", (Object)clientSock.getRemoteSocketAddress());
                try {
                    this.processStream(clientSock.getInputStream());
                }
                finally {
                    LOGGER.info("Closing client: {}", (Object)clientSock.getRemoteSocketAddress());
                    clientSock.close();
                }
            }
            catch (SocketTimeoutException clientSock) {
            }
            catch (IOException e) {
                LOGGER.error("IO error", (Throwable)e);
            }
        }
    }

    private static final class DefaultServerSocketFactory
    extends ServerSocketFactory {
        private DefaultServerSocketFactory() {
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port);
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return new ServerSocket(port, backlog);
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            return new ServerSocket(port, backlog, ifAddress);
        }
    }
}

