/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.launcher.logging;

import com.ibm.ba.flint.launcher.logging.LogEvent;
import com.ibm.ba.flint.launcher.logging.LogEventHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SLF4JLogEventHandler
implements LogEventHandler {
    private final ConcurrentMap<String, Logger> name2Logger = new ConcurrentHashMap<String, Logger>();

    private static String buildMessage(LogEvent e) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{e.getThreadName()})) {
            builder.append("[Thread:").append(e.getThreadName()).append("] ");
        }
        builder.append(e.getMessage());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{e.getNdc()})) {
            builder.append("\nNDC[").append(e.getNdc()).append(']');
        }
        if (null != e.getLocationInfo()) {
            builder.append("\n").append(e.getLocationInfo()).append(']');
        }
        if (null != e.getThrowable() && e.getThrowable().length > 0) {
            for (String line : e.getThrowable()) {
                builder.append("\n").append(line);
            }
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleEvent(LogEvent e) {
        Logger logger = this.getLogger(e.getLoggerName());
        String message = SLF4JLogEventHandler.buildMessage(e);
        Map mdcBackup = MDC.getCopyOfContextMap();
        try {
            this.updateMDC(e.getMdc());
            switch (e.getLevel()) {
                case DEBUG: {
                    logger.debug(message);
                    return;
                }
                case ERROR: 
                case FATAL: {
                    logger.error(message);
                    return;
                }
                case INFO: {
                    logger.info(message);
                    return;
                }
                case TRACE: {
                    logger.trace(message);
                    return;
                }
                case WARN: {
                    logger.warn(message);
                    return;
                }
            }
            return;
        }
        finally {
            if (null != mdcBackup) {
                MDC.setContextMap((Map)mdcBackup);
            } else {
                MDC.clear();
            }
        }
    }

    private Logger getLogger(String name) {
        return this.name2Logger.computeIfAbsent(name, LoggerFactory::getLogger);
    }

    private void updateMDC(Map<String, String> mdc) {
        if (null == mdc || mdc.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> e : mdc.entrySet()) {
            MDC.put((String)e.getKey(), (String)e.getValue());
        }
    }
}

