/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Source;
import org.apache.abdera.parser.stax.FOMElement;
import org.apache.abdera.parser.stax.FOMSource;
import org.apache.abdera.util.Constants;
import org.apache.axiom.core.CoreChildNodeSupport;
import org.apache.axiom.core.CoreParentNodeSupport;
import org.apache.axiom.fom.AbderaElement;
import org.apache.axiom.fom.AbderaEntry;
import org.apache.axiom.fom.AbderaFeed;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomElementSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMFeed
extends FOMSource
implements AbderaFeed {
    public List<Entry> getEntries() {
        return this._getChildrenAsSet(Constants.ENTRY);
    }

    public Feed addEntry(Entry entry) {
        this._addChild((AbderaEntry)entry);
        return this;
    }

    public Entry addEntry() {
        return this.getFactory().newEntry((Base)this);
    }

    public Feed insertEntry(Entry entry) {
        OMElement el = (OMElement)this._getFirstChildWithName(Constants.ENTRY);
        if (el == null) {
            this.addEntry(entry);
        } else {
            el.insertSiblingBefore((OMNode)((OMElement)entry));
        }
        return this;
    }

    public Entry insertEntry() {
        Entry entry = this.getFactory().newEntry(null);
        this.insertEntry(entry);
        return entry;
    }

    public Source getAsSource() {
        FOMSource source = (FOMSource)this.getFactory().newSource(null);
        Iterator i = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getChildElements(this);
        while (i.hasNext()) {
            FOMElement child = (FOMElement)i.next();
            if (child.getQName().equals(Constants.ENTRY)) continue;
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild(source, (OMNode)child.clone());
        }
        try {
            if (this.getBaseUri() != null) {
                source.setBaseUri(this.getBaseUri());
            }
        }
        catch (Exception exception) {}
        return source;
    }

    @Override
    public void _addChild(AbderaElement element) {
        AbderaElement entry;
        if (!(element instanceof Entry) && (entry = this._getFirstChildWithName(Constants.ENTRY)) != null) {
            CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreInsertSiblingBefore(entry, element);
            return;
        }
        CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreAppendChild(this, element, false);
    }

    public Feed sortEntriesByUpdated(boolean new_first) {
        this.sortEntries(new UpdatedComparator(new_first));
        return this;
    }

    public Feed sortEntriesByEdited(boolean new_first) {
        this.sortEntries(new EditedComparator(new_first));
        return this;
    }

    public Feed sortEntries(Comparator<Entry> comparator) {
        if (comparator == null) {
            return this;
        }
        List<Entry> entries = this.getEntries();
        Entry[] a = entries.toArray(new Entry[entries.size()]);
        Arrays.sort(a, comparator);
        for (Entry e : entries) {
            e.discard();
        }
        Entry[] entryArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Entry e;
            e = entryArray[n2];
            this.addEntry(e);
            ++n2;
        }
        return this;
    }

    public Entry getEntry(String id) {
        if (id == null) {
            return null;
        }
        List<Entry> l = this.getEntries();
        for (Entry e : l) {
            IRI eid = e.getId();
            if (eid == null || !eid.equals((Object)new IRI(id))) continue;
            return e;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EditedComparator
    implements Comparator<Entry> {
        private boolean new_first = true;

        EditedComparator(boolean new_first) {
            this.new_first = new_first;
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            Date d1 = o1.getEdited();
            Date d2 = o2.getEdited();
            if (d1 == null) {
                d1 = o1.getUpdated();
            }
            if (d2 == null) {
                d2 = o2.getUpdated();
            }
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null && d2 != null) {
                return -1;
            }
            if (d1 != null && d2 == null) {
                return 1;
            }
            int r = d1.compareTo(d2);
            return this.new_first ? -r : r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdatedComparator
    implements Comparator<Entry> {
        private boolean new_first = true;

        UpdatedComparator(boolean new_first) {
            this.new_first = new_first;
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            Date d1 = o1.getUpdated();
            Date d2 = o2.getUpdated();
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null && d2 != null) {
                return -1;
            }
            if (d1 != null && d2 == null) {
                return 1;
            }
            int r = d1.compareTo(d2);
            return this.new_first ? -r : r;
        }
    }
}

