/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.shaded.org.apache.log.output.io;

import com.ibm.bi.cognos.shaded.org.apache.log.format.Formatter;
import com.ibm.bi.cognos.shaded.org.apache.log.output.io.StreamTarget;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileTarget
extends StreamTarget {
    private File m_file;
    private boolean m_append;

    public FileTarget(File file, boolean append, Formatter formatter) throws IOException {
        super(null, formatter);
        if (null != file) {
            this.setFile(file, append);
            this.openFile();
        }
    }

    protected synchronized void setFile(File file, boolean append) throws IOException {
        if (null == file) {
            throw new NullPointerException("file property must not be null");
        }
        if (this.isOpen()) {
            throw new IOException("target must be closed before file property can be set");
        }
        this.m_append = append;
        this.m_file = file;
    }

    protected synchronized void openFile() throws IOException {
        File file;
        File parent;
        if (this.isOpen()) {
            this.close();
        }
        if (null != (parent = (file = this.getFile().getCanonicalFile()).getParentFile()) && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file.getPath(), this.m_append);
        this.setOutputStream(outputStream);
        this.open();
    }

    protected synchronized File getFile() {
        return this.m_file;
    }
}

