/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.shaded.org.apache.log.output.io;

import com.ibm.bi.cognos.shaded.org.apache.log.LogEvent;
import com.ibm.bi.cognos.shaded.org.apache.log.format.Formatter;
import com.ibm.bi.cognos.shaded.org.apache.log.output.io.FileTarget;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SafeFileTarget
extends FileTarget {
    public SafeFileTarget(File file, boolean append, Formatter formatter) throws IOException {
        super(file, append, formatter);
        this.shutdownStream();
    }

    public synchronized void processEvent(LogEvent event) {
        if (!this.isOpen()) {
            this.getErrorHandler().error("Writing event to closed stream.", null, event);
            return;
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(this.getFile().getPath(), true);
            this.setOutputStream(outputStream);
        }
        catch (Throwable throwable) {
            this.getErrorHandler().error("Unable to open file to write log event.", throwable, event);
            return;
        }
        super.processEvent(event);
        this.shutdownStream();
    }
}

