/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.shaded.org.apache.log.output.io;

import com.ibm.bi.cognos.shaded.org.apache.log.format.Formatter;
import com.ibm.bi.cognos.shaded.org.apache.log.output.AbstractOutputTarget;
import java.io.IOException;
import java.io.OutputStream;

public class StreamTarget
extends AbstractOutputTarget {
    private OutputStream m_outputStream;

    public StreamTarget(OutputStream outputStream, Formatter formatter) {
        super(formatter);
        if (null != outputStream) {
            this.setOutputStream(outputStream);
            this.open();
        }
    }

    protected synchronized void setOutputStream(OutputStream outputStream) {
        if (null == outputStream) {
            throw new NullPointerException("outputStream property must not be null");
        }
        this.m_outputStream = outputStream;
    }

    protected synchronized void write(String data) {
        OutputStream outputStream = this.m_outputStream;
        if (null == outputStream) {
            String message = "Attempted to write data '" + data + "' to Null OutputStream";
            this.getErrorHandler().error(message, null, null);
            return;
        }
        try {
            outputStream.write(data.getBytes());
            outputStream.flush();
        }
        catch (IOException ioe) {
            String message = "Error writing data '" + data + "' to OutputStream";
            this.getErrorHandler().error(message, ioe, null);
        }
    }

    public synchronized void close() {
        super.close();
        this.shutdownStream();
    }

    protected synchronized void shutdownStream() {
        OutputStream outputStream = this.m_outputStream;
        this.m_outputStream = null;
        try {
            if (null != outputStream) {
                outputStream.close();
            }
        }
        catch (IOException ioe) {
            this.getErrorHandler().error("Error closing OutputStream", ioe, null);
        }
    }
}

