/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.shaded.org.apache.log.output.jms;

import com.ibm.bi.cognos.shaded.org.apache.log.ErrorHandler;
import com.ibm.bi.cognos.shaded.org.apache.log.output.jms.AbstractJMSTarget;
import com.ibm.bi.cognos.shaded.org.apache.log.output.jms.MessageBuilder;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class JMSTopicTarget
extends AbstractJMSTarget {
    private TopicConnectionFactory m_factory;
    private Topic m_topic;
    private TopicSession m_session;
    private TopicPublisher m_publisher;
    private TopicConnection m_connection;

    public JMSTopicTarget(MessageBuilder builder, TopicConnectionFactory factory, Topic topic) {
        super(builder);
        this.m_factory = factory;
        this.m_topic = topic;
        this.open();
    }

    public JMSTopicTarget(MessageBuilder builder, TopicConnectionFactory factory, Topic topic, ErrorHandler handler) {
        super(builder, handler);
        this.m_factory = factory;
        this.m_topic = topic;
        this.open();
    }

    protected void send(Message message) {
        try {
            this.m_publisher.publish(message);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error publishing message", e, null);
        }
    }

    protected Session getSession() {
        return this.m_session;
    }

    protected synchronized void openConnection() {
        try {
            this.m_connection = this.m_factory.createTopicConnection();
            this.m_connection.start();
            this.m_session = this.m_connection.createTopicSession(false, 1);
            this.m_publisher = this.m_session.createPublisher(this.m_topic);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error starting connection", e, null);
        }
    }

    protected synchronized void closeConnection() {
        try {
            if (null != this.m_publisher) {
                this.m_publisher.close();
            }
            if (null != this.m_session) {
                this.m_session.close();
            }
            if (null != this.m_connection) {
                this.m_connection.close();
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error closing connection", e, null);
        }
        this.m_publisher = null;
        this.m_session = null;
        this.m_connection = null;
    }
}

