/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.shaded.org.apache.log.output.lf5;

import com.ibm.bi.cognos.shaded.org.apache.log.ContextMap;
import com.ibm.bi.cognos.shaded.org.apache.log.LogEvent;
import com.ibm.bi.cognos.shaded.org.apache.log.Priority;
import com.ibm.bi.cognos.shaded.org.apache.log.format.Formatter;
import com.ibm.bi.cognos.shaded.org.apache.log.util.StackIntrospector;
import com.ibm.bi.cognos.shaded.org.apache.log4j.lf5.LogLevel;
import com.ibm.bi.cognos.shaded.org.apache.log4j.lf5.LogRecord;
import java.util.Arrays;
import java.util.List;

public class LogKitLogRecord
extends LogRecord {
    private boolean m_severe;
    public static final List LOGKIT_LOGLEVELS = Arrays.asList(LogLevel.FATAL, LogLevel.ERROR, LogLevel.WARN, LogLevel.INFO, LogLevel.DEBUG);
    static /* synthetic */ Class class$org$apache$log$Logger;

    public LogKitLogRecord(LogEvent event, Formatter fmt) {
        Object contextObject;
        ContextMap contextMap = event.getContextMap();
        this.setCategory(event.getCategory());
        this.setLevel(this.toLogLevel(event.getPriority()));
        this.m_severe = event.getPriority().isGreater(Priority.INFO);
        if (null != contextMap && null != (contextObject = contextMap.get("method"))) {
            this.setLocation(contextObject.toString());
        } else {
            this.setLocation(StackIntrospector.getCallerMethod(class$org$apache$log$Logger == null ? (class$org$apache$log$Logger = LogKitLogRecord.class$("com.ibm.bi.cognos.shaded.org.apache.log.Logger")) : class$org$apache$log$Logger));
        }
        this.setMessage(event.getMessage());
        this.setMillis(event.getTime());
        this.setNDC(fmt.format(event));
        if (null != contextMap && null != (contextObject = contextMap.get("thread"))) {
            this.setThreadDescription(contextObject.toString());
        } else {
            this.setThreadDescription(Thread.currentThread().getName());
        }
        this.setThrown(event.getThrowable());
    }

    public boolean isSevereLevel() {
        return this.m_severe;
    }

    public LogLevel toLogLevel(Priority priority) {
        if (Priority.DEBUG == priority) {
            return LogLevel.DEBUG;
        }
        if (Priority.INFO == priority) {
            return LogLevel.INFO;
        }
        if (Priority.WARN == priority) {
            return LogLevel.WARN;
        }
        if (Priority.ERROR == priority) {
            return LogLevel.ERROR;
        }
        if (Priority.FATAL_ERROR == priority) {
            return LogLevel.FATAL;
        }
        return new LogLevel(priority.getName(), priority.getValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

