/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.shaded.org.apache.log.output.net;

import com.ibm.bi.cognos.shaded.org.apache.log.LogEvent;
import com.ibm.bi.cognos.shaded.org.apache.log.output.AbstractOutputTarget;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class SocketOutputTarget
extends AbstractOutputTarget {
    private Socket m_socket;
    private ObjectOutputStream m_outputStream;

    public SocketOutputTarget(InetAddress address, int port) throws IOException {
        this.m_socket = new Socket(address, port);
        this.m_outputStream = new ObjectOutputStream(this.m_socket.getOutputStream());
    }

    public SocketOutputTarget(String host, int port) throws IOException {
        this.m_socket = new Socket(host, port);
        this.m_outputStream = new ObjectOutputStream(this.m_socket.getOutputStream());
    }

    protected void write(LogEvent event) {
        try {
            this.m_outputStream.writeObject(event);
        }
        catch (IOException ioex) {
            this.getErrorHandler().error("Error writting to socket", ioex, null);
        }
    }

    protected void doProcessEvent(LogEvent event) {
        this.write(event);
    }

    public synchronized void close() {
        super.close();
        this.m_socket = null;
    }
}

