/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.caf;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.validator.api.Document;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;
import com.ibm.cognos.internal.annotations.caf.AnnotationParameterUpdater;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class AnnotationCafValidator {
    private static final String CLASS_NAME = AnnotationCafValidator.class.getName();
    private ValidatorFactory validatorFactory = null;
    private VerifySession verifySession = null;

    public AnnotationCafValidator() throws AnnotationServiceException {
        try {
            this.validatorFactory = ValidatorFactory.newInstance();
            this.validatorFactory.put(0, true);
            this.validatorFactory.put(1, true);
            this.validatorFactory.put(2, true);
            Document doc = this.validatorFactory.createDocument();
            InputStream dataStream = this.getClass().getResourceAsStream("/com/ibm/cognos/internal/annotations/caf/cafRules.xml");
            InputStreamReader inputStreamReader = new InputStreamReader(dataStream);
            doc.loadFromXML((Reader)inputStreamReader);
            String compiledDoc = doc.compile(CLASS_NAME);
            doc.loadFromCompile(compiledDoc, CLASS_NAME);
            this.verifySession = this.validatorFactory.createVerifySession(doc);
            this.verifySession.put(0, true);
        }
        catch (ValidatorException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, (Throwable)e);
        }
        catch (VerifyException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, (Throwable)e);
        }
    }

    public void validate(BIBusEnvelope env) throws AnnotationServiceException {
        AnnotationParameterUpdater paramUpdater = new AnnotationParameterUpdater(env.getFormFieldValues());
        try {
            this.verifySession.verify((IParameterUpdater)paramUpdater);
        }
        catch (ValidatorException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, e, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        catch (VerifyException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, e, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
    }
}

