/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.users.CMPolicyProperties;
import com.ibm.cognos.internal.annotations.users.CMPolicyPropertiesImpl;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import com.ibm.cognos.internal.annotations.users.CMPropertiesImpl;
import com.ibm.cognos.internal.annotations.users.MultiCMProperties;
import com.ibm.cognos.internal.annotations.users.MultiCMPropertiesImpl;
import com.ibm.cognos.internal.annotations.users.Session;
import com.ibm.cognos.internal.annotations.users.SessionImpl;
import com.ibm.cognos.internal.annotations.users.UserImpl;
import java.util.Iterator;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Element;

public abstract class AnnotationCommand {
    private MessageContext mc;
    private AnnotationResources resources;

    public AnnotationResources getResources() {
        return this.resources;
    }

    public AnnotationCommand(MessageContext mc, AnnotationResources resources) {
        this.mc = mc;
        this.resources = resources;
    }

    public abstract Element performSoapAction() throws AnnotationServiceException;

    public abstract RestResponse performRestAction(String var1) throws AnnotationServiceException;

    protected Element getOperationElement() throws AnnotationServiceException {
        Element operationElement = null;
        Element body = this.getRequest().getBody();
        if (body != null) {
            if (operationElement == null) {
                Iterator bodyIterator = body.elementIterator();
                if (!bodyIterator.hasNext()) {
                    throw new AnnotationServiceException(AnnotationI18NCode.EMPTY_ANNOTATION_OPERATION, AnnotationServiceException.FaultType.REQUEST_ERROR);
                }
                operationElement = (Element)bodyIterator.next();
            }
        } else {
            throw new AnnotationServiceException(AnnotationI18NCode.EMPTY_SOAP_BODY, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        return operationElement;
    }

    CMProperties getUser() {
        UserImpl user = new UserImpl(this.getResources().getClientFactory(), this.getRequest());
        user.setRequestorOperation(this.getRequestorOperation());
        return user;
    }

    Session getSession() {
        SessionImpl session = new SessionImpl(this.getResources().getClientFactory(), this.getRequest());
        session.setRequestorOperation(this.getRequestorOperation());
        return session;
    }

    CMPolicyProperties getCMPolicyProperties(String baseClassID) {
        CMPolicyPropertiesImpl cmProperties = new CMPolicyPropertiesImpl(baseClassID, this.getResources().getClientFactory(), this.getRequest());
        cmProperties.setRequestorOperation(this.getRequestorOperation());
        return cmProperties;
    }

    CMProperties getCMProperties(String baseClassID) {
        CMPropertiesImpl cmProperties = new CMPropertiesImpl(baseClassID, this.getResources().getClientFactory(), this.getRequest());
        cmProperties.setRequestorOperation(this.getRequestorOperation());
        return cmProperties;
    }

    MultiCMProperties getMultiCMPropertiesRequest(CMProperties[] properties) {
        MultiCMPropertiesImpl multiCMProperties = new MultiCMPropertiesImpl(properties, this.getResources().getClientFactory(), this.getRequest());
        multiCMProperties.setRequestorOperation(this.getRequestorOperation());
        return multiCMProperties;
    }

    private String getRequestorOperation() {
        boolean bRestReq;
        String requestorOperation = null;
        InternetHeaders hdrs = (InternetHeaders)this.mc.getProperty("request.headers");
        String[] sAction = hdrs.getHeader("soapAction");
        boolean bl = bRestReq = sAction == null;
        if (bRestReq) {
            String pathInfo = (String)this.mc.getProperty("path_info");
            String httpMethod = (String)this.mc.getProperty("request.method");
            String[] parts = pathInfo.split("/");
            if (parts.length > 2) {
                String resource_type = parts[2];
                requestorOperation = httpMethod + "_" + resource_type;
            }
        } else {
            Element operationElement;
            BIBusEnvelope requestEnv = (BIBusEnvelope)this.mc.getProperty("request.envelope");
            Element body = requestEnv.getBody();
            if (body != null && (operationElement = (Element)body.selectSingleNode("./*")) != null) {
                requestorOperation = operationElement.getName();
            }
        }
        return requestorOperation;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    protected BIBusEnvelope getRequest() {
        return (BIBusEnvelope)this.mc.getProperty("request.envelope");
    }
}

