/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.convert.serialize.Serializer;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerContextImpl;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerFactory;
import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.CMPolicyProperties;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import com.ibm.cognos.internal.annotations.users.MultiCMProperties;
import com.ibm.cognos.internal.annotations.users.Session;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class AtomFeedCommand
extends AnnotationCommand {
    private static final Namespace NS_ATOM = Namespace.get((String)"atom", (String)"http://www.w3.org/2005/Atom");
    private static final QName ATOM_FEED = new QName("feed", NS_ATOM);
    private static final QName ATOM_ID = new QName("id", NS_ATOM);
    private static final QName ATOM_SUBTITLE = new QName("subtitle", NS_ATOM);
    private static final QName ATOM_LINK = new QName("link", NS_ATOM);
    private static final QName ATOM_TITLE = new QName("title", NS_ATOM);
    private static final QName ATOM_UPDATED = new QName("updated", NS_ATOM);
    private static final QName ATOM_ENTRY = new QName("entry", NS_ATOM);
    private static final QName ATOM_AUTHOR = new QName("author", NS_ATOM);
    private static final QName ATOM_NAME = new QName("name", NS_ATOM);
    private static final QName ATOM_SUMMARY = new QName("summary", NS_ATOM);
    private static final QName ATOM_CONTENT = new QName("content", NS_ATOM);
    private static final String ATOM_REL_ATTRIBUTE = "rel";
    private static final String ATOM_HREF_ATTRIBUTE = "href";
    private static final String ATOM_TYPE_ATTRIBURE = "type";

    public AtomFeedCommand(MessageContext mc, AnnotationResources resources) {
        super(mc, resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestResponse performRestAction(String sourceID) throws AnnotationServiceException {
        EntityManager em = null;
        QueryResults results = null;
        Element feedElement = null;
        Session identity = this.getSession();
        identity.getCMInfo();
        if (!identity.isAdministrator()) {
            throw new AnnotationServiceException(AnnotationI18NCode.NOT_ADMINISTRATOR);
        }
        try {
            em = this.getResources().getEntityManagerFactory().createEntityManager();
            results = this.executeQuery(em);
            feedElement = this.buildAtomDocument(results);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return new RestResponse(feedElement.asXML(), "application/atom+xml");
    }

    private Element buildAtomDocument(QueryResults results) throws AnnotationServiceException {
        String gateway = null;
        try {
            CRNProperties properties = this.getResources().getConfiguration();
            gateway = properties.getProperty("gateway");
        }
        catch (PropertiesException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.GET_PROPERTY_FAILED, new Object[]{"gateway"});
        }
        Document doc = DocumentHelper.createDocument();
        Element feedElement = doc.addElement(ATOM_FEED);
        Element idElement = feedElement.addElement(ATOM_ID);
        Element subtitleElement = feedElement.addElement(ATOM_SUBTITLE);
        Element selfLinkElement = feedElement.addElement(ATOM_LINK);
        selfLinkElement.addAttribute(ATOM_REL_ATTRIBUTE, "self");
        selfLinkElement.addAttribute(ATOM_TYPE_ATTRIBURE, "application/atom+xml");
        selfLinkElement.addAttribute(ATOM_HREF_ATTRIBUTE, gateway + "/annotations/atom");
        ArrayList<Element> entryElements = new ArrayList<Element>();
        Iterator<?> it = results.results.iterator();
        for (int i = 0; i < results.pageSize && it.hasNext(); ++i) {
            Annotation annotation = (Annotation)it.next();
            Element atomEntryElement = this.buildAtomEntry(annotation);
            if (atomEntryElement == null) continue;
            entryElements.add(atomEntryElement);
        }
        if (it.hasNext()) {
            Element nextLinkElement = feedElement.addElement(ATOM_LINK);
            nextLinkElement.addAttribute(ATOM_REL_ATTRIBUTE, "nextPage");
            nextLinkElement.addAttribute(ATOM_TYPE_ATTRIBURE, "application/atom+xml");
            nextLinkElement.addAttribute(ATOM_HREF_ATTRIBUTE, gateway + "/annotations/atom" + results.getNextPageURI());
        }
        Element titleElement = feedElement.addElement(ATOM_TITLE);
        Element updatedElement = feedElement.addElement(ATOM_UPDATED);
        for (Element e : entryElements) {
            feedElement.add(e);
        }
        return feedElement;
    }

    private Element buildAtomEntry(Annotation annotation) throws AnnotationServiceException {
        CMPolicyProperties parentCMProps = this.getCMPolicyProperties(annotation.getParentId());
        CMProperties ownerCMProps = this.getCMProperties(annotation.getOwner());
        CMProperties secondaryParentCMProps = null;
        if (annotation.getSecondaryParentId() != null) {
            secondaryParentCMProps = this.getCMProperties(annotation.getSecondaryParentId());
        }
        MultiCMProperties multiRequest = annotation.getSecondaryParentId() == null ? this.getMultiCMPropertiesRequest(new CMProperties[]{parentCMProps, ownerCMProps}) : this.getMultiCMPropertiesRequest(new CMProperties[]{parentCMProps, secondaryParentCMProps, ownerCMProps});
        multiRequest.getCMInfo();
        Document entryDocument = DocumentHelper.createDocument();
        Element entryElement = entryDocument.addElement(ATOM_ENTRY);
        Element titleElement = entryElement.addElement(ATOM_TITLE);
        titleElement.addAttribute(ATOM_TYPE_ATTRIBURE, "text");
        if (annotation.getText().getName() != null) {
            titleElement.addText(annotation.getText().getName());
        }
        Element idEntryElement = entryElement.addElement(ATOM_ID);
        idEntryElement.addText("" + annotation.getId());
        Element updatedEntryElement = entryElement.addElement(ATOM_UPDATED);
        updatedEntryElement.addText(XMLSOAPHelper.dateTimeFormat.format(annotation.getLastModificationTime()));
        Element authorElement = entryElement.addElement(ATOM_AUTHOR);
        Element authorNameElement = authorElement.addElement(ATOM_NAME);
        authorNameElement.setText(ownerCMProps.getDefaultName());
        Element summaryElement = entryElement.addElement(ATOM_SUMMARY);
        summaryElement.addAttribute(ATOM_TYPE_ATTRIBURE, "text");
        if (annotation.getText().getDescription() != null) {
            summaryElement.addText(annotation.getText().getDescription());
        }
        Element contentElement = entryElement.addElement(ATOM_CONTENT);
        contentElement.addAttribute(ATOM_TYPE_ATTRIBURE, "application/xml");
        Element policies = parentCMProps.getPolicies();
        SerializerFactory serializerFactory = this.getResources().getSerializerFactory();
        Serializer serializer = serializerFactory.getSerializer(annotation, new SerializerContextImpl(this.getRequest()));
        Element serializedAnnotationElement = serializer.convert();
        Element parentElement = serializedAnnotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID);
        parentElement.clearContent();
        parentElement.add(parentCMProps.getCMRef());
        Element ownerElement = serializedAnnotationElement.element(XMLSOAPHelper.ANNOTATION_OWNER);
        ownerElement.clearContent();
        ownerElement.add(ownerCMProps.getCMRef());
        if (annotation.getSecondaryParentId() != null) {
            Element secondaryParentElement = serializedAnnotationElement.element(XMLSOAPHelper.ANNOTATION_SECONDARY_PARENTID);
            secondaryParentElement.clearContent();
            secondaryParentElement.add(secondaryParentCMProps.getCMRef());
        }
        contentElement.add(serializedAnnotationElement);
        serializedAnnotationElement.add(policies);
        entryElement.detach();
        return entryElement;
    }

    private QueryResults executeQuery(EntityManager em) throws AnnotationServiceException {
        String pageSizeFormValue = this.getRequest().getFormValue("pageSize");
        String pageNumberFormValue = this.getRequest().getFormValue("pageNumber");
        String timeStampFormValue = this.getRequest().getFormValue("timestamp");
        if (pageSizeFormValue == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.INVALID_PAGE_SIZE);
        }
        if (pageNumberFormValue == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.INVALID_PAGE_NUMBER);
        }
        int pageSize = Integer.parseInt(pageSizeFormValue);
        int pageNumber = Integer.parseInt(pageNumberFormValue);
        if (pageNumber < 1) {
            throw new AnnotationServiceException(AnnotationI18NCode.INVALID_PAGE_NUMBER);
        }
        AnnotationDAO annotationDAO = this.getResources().getDAOFactory().buildDAO(AnnotationDAO.class);
        List results = null;
        Query annotationQuery = null;
        if (timeStampFormValue == null) {
            annotationQuery = annotationDAO.findAll(em);
        } else {
            Date timeFrom = null;
            try {
                timeFrom = XMLSOAPHelper.dateTimeFormat.parse(timeStampFormValue);
            }
            catch (ParseException e) {
                throw new AnnotationServiceException(AnnotationI18NCode.INVALID_DATE_FORMAT, new Object[]{timeStampFormValue}, e, AnnotationServiceException.FaultType.REQUEST_ERROR);
            }
            annotationQuery = annotationDAO.findNewUpdatedAnnotations(em, timeFrom);
        }
        annotationQuery.setFirstResult((pageNumber - 1) * pageSize);
        annotationQuery.setMaxResults(pageSize + 1);
        results = annotationQuery.getResultList();
        return new QueryResults(pageSize, pageNumber, timeStampFormValue, results);
    }

    @Override
    public Element performSoapAction() throws AnnotationServiceException {
        throw new AnnotationServiceException(AnnotationI18NCode.NOT_IMPLEMENTED);
    }

    private class QueryResults {
        public int pageSize;
        public int pageNum;
        public String timestamp;
        public List<?> results;

        public QueryResults(int pageSize, int pageNum, String timestamp, List<?> results) {
            this.pageNum = pageNum;
            this.pageSize = pageSize;
            this.timestamp = timestamp;
            this.results = results;
        }

        public String getNextPageURI() {
            String ret_value = "?pageSize=" + this.pageSize + "&pageNumber=" + (this.pageNum + 1);
            if (this.timestamp != null) {
                ret_value = ret_value + "&timestamp=" + this.timestamp;
            }
            return ret_value;
        }
    }
}

