/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationAuthenticationException;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.metrics.AnnotationPerfMBeanImpl;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.Session;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CheckAnnotationCommand
extends AnnotationCommand {
    public CheckAnnotationCommand(MessageContext mc, AnnotationResources resources) {
        super(mc, resources);
    }

    @Override
    public RestResponse performRestAction(String sourceID) throws AnnotationServiceException {
        throw new AnnotationServiceException(AnnotationI18NCode.NOT_IMPLEMENTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element performSoapAction() throws AnnotationServiceException {
        Session identity = this.getSession();
        identity.getCMInfo();
        if (!identity.isAdministrator()) {
            throw new AnnotationServiceException(AnnotationI18NCode.NOT_ADMINISTRATOR);
        }
        Element operationElement = this.getOperationElement();
        ArrayList<Long> idArray = new ArrayList<Long>();
        this.getRequestIDs(operationElement, idArray);
        EntityManager em = this.getResources().getEntityManagerFactory().createEntityManager();
        List<AnnotationResult> annotationResults = null;
        try {
            annotationResults = this.getAnnotations(em, idArray);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        this.getParents(annotationResults);
        return this.buildResponse(idArray, annotationResults);
    }

    private void getRequestIDs(Element operationElement, ArrayList<Long> idArray) throws AnnotationServiceException {
        Element annotationsElement = operationElement.element(XMLSOAPHelper.ANN_ANNOTATIONS_ELEMENT);
        if (annotationsElement == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.NO_ANNOTATIONS_ELEMENT);
        }
        List annotationElements = annotationsElement.elements(XMLSOAPHelper.ANNOTATION_ELEMENT);
        for (Element annotationElement : annotationElements) {
            String id;
            Element idElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_ID);
            if (idElement == null || (id = idElement.getText()) == null) continue;
            Long idLong = null;
            try {
                idLong = Long.parseLong(id);
            }
            catch (NumberFormatException e) {
                throw new AnnotationServiceException(AnnotationI18NCode.INVALID_ANNOTATION_ID, new Object[]{id}, e);
            }
            idArray.add(idLong);
        }
    }

    private List<AnnotationResult> getAnnotations(EntityManager em, List<Long> idArray) throws AnnotationServiceException {
        ArrayList<AnnotationResult> annotationResults = new ArrayList<AnnotationResult>();
        AnnotationDAO annotationDAO = this.getResources().getDAOFactory().buildDAO(AnnotationDAO.class);
        List annotationList = annotationDAO.findAnnotationsGivenIDs(em, idArray).getResultList();
        for (Annotation annotation : annotationList) {
            AnnotationResult annotationResult = new AnnotationResult(annotation.getId(), annotation.getParentId());
            annotationResults.add(annotationResult);
        }
        return annotationResults;
    }

    private void getParents(List<AnnotationResult> annotationResults) throws AnnotationServiceException {
        ArrayList<QueryRequest> cmRequests = new ArrayList<QueryRequest>();
        for (AnnotationResult annotationResult : annotationResults) {
            QueryRequest cmRequest = new QueryRequest();
            cmRequest.setSearch("storeID('" + annotationResult.parentId + "')");
            cmRequest.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID});
            cmRequests.add(cmRequest);
        }
        BiBusHeader header = BiBusUtilities.retrieveHeader((BIBusEnvelope)this.getRequest());
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        ContentManagerServiceClientPort cm_port = this.getResources().getClientFactory().getContentManagerServiceClient(headers);
        QueryReply[] cmReplies = null;
        Date perf_start = new Date();
        try {
            cmReplies = cm_port.queryMultiple(cmRequests.toArray(new QueryRequest[0]));
        }
        catch (EMFSecurityException e) {
            throw new AnnotationAuthenticationException(e);
        }
        catch (SDKClientException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.SDK_CLIENT_EXCEPTION, (Throwable)e);
        }
        finally {
            AnnotationPerfMBeanImpl.getInstance().incrementCmRequestCount();
            AnnotationPerfMBeanImpl.getInstance().updateTimeInCM(perf_start, new Date());
            if (cm_port != null) {
                cm_port.close();
            }
        }
        Iterator<AnnotationResult> it = annotationResults.iterator();
        int i = 0;
        while (it.hasNext()) {
            QueryReply queryReply;
            BaseClass[] baseClasses;
            AnnotationResult result = it.next();
            if ((baseClasses = (queryReply = cmReplies[i++]).getQueryResult()) == null || baseClasses.length != 1) continue;
            result.setBaseClass(baseClasses[0]);
        }
    }

    private Element buildResponse(List<Long> idArray, List<AnnotationResult> annotationResults) {
        Document document = DocumentHelper.createDocument();
        Hashtable<Long, AnnotationResult> processedResults = new Hashtable<Long, AnnotationResult>();
        for (AnnotationResult annotationResult : annotationResults) {
            processedResults.put(annotationResult.id, annotationResult);
        }
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_CHECK_RESPONSE);
        Element annotationsElement = responseElement.addElement(XMLSOAPHelper.ANN_ANNOTATIONS_ELEMENT);
        for (Long id : idArray) {
            Element annotationElement = annotationsElement.addElement(XMLSOAPHelper.ANNOTATION_ELEMENT);
            Element idElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_ID);
            idElement.setText("" + id);
            Element validElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_VALID);
            String validText = "false";
            if (processedResults.containsKey(id) && ((AnnotationResult)processedResults.get(id)).valid()) {
                validText = "true";
            }
            validElement.setText(validText);
        }
        responseElement.detach();
        return responseElement;
    }

    private class AnnotationResult {
        public Long id;
        public String parentId;
        public BaseClass baseClass;

        public AnnotationResult(Long id, String parentId) {
            this.id = id;
            this.parentId = parentId;
        }

        public void setBaseClass(BaseClass baseClass) {
            this.baseClass = baseClass;
        }

        public boolean valid() {
            return this.id > 0L && this.baseClass != null;
        }
    }
}

