/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.PersistResult;
import com.ibm.cognos.internal.annotations.persist.PersistorContext;
import com.ibm.cognos.internal.annotations.persist.PersistorContextImpl;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.pojos.AnnotationProperty;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import com.ibm.cognos.internal.annotations.users.MultiCMProperties;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CloneAnnotationCommand
extends AnnotationCommand {
    public CloneAnnotationCommand(MessageContext mc, AnnotationResources resources) {
        super(mc, resources);
    }

    @Override
    public RestResponse performRestAction(String sourceID) throws AnnotationServiceException {
        throw new AnnotationServiceException(AnnotationI18NCode.NOT_IMPLEMENTED);
    }

    @Override
    public Element performSoapAction() throws AnnotationServiceException {
        Element responseElement = null;
        Element operationElement = this.getOperationElement();
        if (operationElement.getQName().equals((Object)XMLSOAPHelper.ANN_CLONE_REQUEST)) {
            responseElement = this.cloneById();
        } else if (operationElement.getQName().equals((Object)XMLSOAPHelper.ANN_CLONE_BY_PARENT_ID_REQUEST)) {
            responseElement = this.cloneByParentId();
        }
        return responseElement;
    }

    private Element cloneById() throws AnnotationServiceException {
        Element idElement;
        Element annotationElement;
        String sourceID = null;
        String targetParentID = null;
        String targetSecondaryParentID = null;
        Element sourceElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_SOURCE);
        Element targetElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_TARGET);
        if (sourceElement != null && (annotationElement = sourceElement.element(XMLSOAPHelper.ANNOTATION_ELEMENT)) != null && (idElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_ID)) != null) {
            sourceID = idElement.getText();
        }
        if (targetElement != null && (annotationElement = targetElement.element(XMLSOAPHelper.ANNOTATION_ELEMENT)) != null) {
            Element secondaryParentElement;
            Element parentElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID);
            if (parentElement != null) {
                targetParentID = parentElement.getText();
            }
            if ((secondaryParentElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_SECONDARY_PARENTID)) != null) {
                targetSecondaryParentID = secondaryParentElement.getText();
            }
        }
        if (sourceID == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (targetParentID == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_PARENT_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        Element cloneMapElement = this.cloneAnnotationById(Long.parseLong(sourceID), targetParentID, targetSecondaryParentID);
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_CLONE_RESPONSE);
        if (cloneMapElement != null) {
            responseElement.add(cloneMapElement);
        }
        responseElement.detach();
        return responseElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element cloneAnnotationById(Long id, String targetParentID, String targetSecondaryParentID) throws AnnotationServiceException {
        Element cloneResponseElement = null;
        EntityManager em = null;
        try {
            em = this.getResources().getEntityManagerFactory().createEntityManager();
            Annotation annotation = (Annotation)em.find(Annotation.class, (Object)id);
            if (annotation == null) {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_NOT_FOUND, new Object[]{id.toString()}, AnnotationServiceException.FaultType.NO_OBJECT);
            }
            CMProperties sourceParentCMProps = this.getCMProperties(annotation.getParentId());
            CMProperties targetParentCMProps = this.getCMProperties(targetParentID);
            CMProperties targetSecondaryParentCMProps = null;
            MultiCMProperties multiCMProperties = null;
            if (targetSecondaryParentID != null) {
                targetSecondaryParentCMProps = this.getCMProperties(targetSecondaryParentID);
                multiCMProperties = this.getMultiCMPropertiesRequest(new CMProperties[]{sourceParentCMProps, targetParentCMProps, targetSecondaryParentCMProps});
            } else {
                multiCMProperties = this.getMultiCMPropertiesRequest(new CMProperties[]{sourceParentCMProps, targetParentCMProps});
            }
            multiCMProperties.getCMInfo();
            if (sourceParentCMProps.readPermission() && targetParentCMProps.readPermission()) {
                Annotation clonedAnnotation = this.clone(annotation, targetParentID, targetSecondaryParentID);
                PersistorContext persistenceContext = this.getPersistorContext(em);
                PersistResult result = new PersistResult();
                result.setPersistedObject(clonedAnnotation);
                result.setFound(false);
                persistenceContext.persist(result);
                cloneResponseElement = this.buildMap(new Long[]{annotation.getId()}, new Long[]{clonedAnnotation.getId()});
            }
            AnnotationLogger.getInstance().logUserRequest("READ", this.getRequest(), annotation);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return cloneResponseElement;
    }

    private Element cloneByParentId() throws AnnotationServiceException {
        Element secondaryParentElement;
        Element parentElement;
        Element annotationElement;
        String sourceParentID = null;
        String sourceSecondaryParentID = null;
        String targetParentID = null;
        String targetSecondaryParentID = null;
        Element sourceElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_SOURCE);
        Element targetElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_TARGET);
        if (sourceElement != null && (annotationElement = sourceElement.element(XMLSOAPHelper.ANNOTATION_ELEMENT)) != null) {
            parentElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID);
            if (parentElement != null) {
                sourceParentID = parentElement.getText();
            }
            if ((secondaryParentElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_SECONDARY_PARENTID)) != null) {
                sourceSecondaryParentID = secondaryParentElement.getText();
            }
        }
        if (targetElement != null && (annotationElement = targetElement.element(XMLSOAPHelper.ANNOTATION_ELEMENT)) != null) {
            parentElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID);
            if (parentElement != null) {
                targetParentID = parentElement.getText();
            }
            if ((secondaryParentElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_SECONDARY_PARENTID)) != null) {
                targetSecondaryParentID = secondaryParentElement.getText();
            }
        }
        if (sourceParentID == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_PARENT_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (targetParentID == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_PARENT_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (sourceSecondaryParentID == null != (targetSecondaryParentID == null)) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_PARENT_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_CLONE_BY_PARENT_ID_RESPONSE);
        Element cloneMapElement = this.cloneAnnotationsByParentID(sourceParentID, sourceSecondaryParentID, targetParentID, targetSecondaryParentID);
        if (cloneMapElement != null) {
            responseElement.add(cloneMapElement);
        }
        responseElement.detach();
        return responseElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element cloneAnnotationsByParentID(String sourceParentID, String sourceSecondaryParentID, String targetParentID, String targetSecondaryParentID) throws AnnotationServiceException {
        Element cloneResponseElement = null;
        EntityManager em = this.getResources().getEntityManagerFactory().createEntityManager();
        try {
            CMProperties sourceParentCMProps = this.getCMProperties(sourceParentID);
            CMProperties targetParentCMProps = this.getCMProperties(targetParentID);
            CMProperties sourceSecondaryParentCMProps = null;
            CMProperties targetSecondaryParentCMProps = null;
            MultiCMProperties multiCMProperties = null;
            if (sourceSecondaryParentID != null) {
                sourceSecondaryParentCMProps = this.getCMProperties(sourceSecondaryParentID);
                targetSecondaryParentCMProps = this.getCMProperties(targetSecondaryParentID);
                multiCMProperties = this.getMultiCMPropertiesRequest(new CMProperties[]{sourceParentCMProps, targetParentCMProps, sourceSecondaryParentCMProps, targetSecondaryParentCMProps});
            } else {
                multiCMProperties = this.getMultiCMPropertiesRequest(new CMProperties[]{sourceParentCMProps, targetParentCMProps});
            }
            multiCMProperties.getCMInfo();
            if (sourceParentCMProps.readPermission() && targetParentCMProps.readPermission()) {
                AnnotationDAO annotationDAO = this.getResources().getDAOFactory().buildDAO(AnnotationDAO.class);
                List queryResults = annotationDAO.findAnnotationsByParentIDs(em, sourceParentID, sourceSecondaryParentID).getResultList();
                ArrayList<Long> oldIDList = new ArrayList<Long>();
                ArrayList<Long> newIDList = new ArrayList<Long>();
                ArrayList<Annotation> newAnnotationList = new ArrayList<Annotation>();
                PersistorContext persistenceContext = this.getPersistorContext(em);
                PersistResult result = new PersistResult();
                result.dontCount();
                for (Annotation annotation : queryResults) {
                    Annotation clonedAnnotation = this.clone(annotation, targetParentID, targetSecondaryParentID);
                    PersistResult aResult = new PersistResult();
                    aResult.setPersistedObject(clonedAnnotation);
                    aResult.setFound(false);
                    result.addChild(aResult);
                    oldIDList.add(annotation.getId());
                    newAnnotationList.add(clonedAnnotation);
                }
                persistenceContext.persist(result);
                int isz = newAnnotationList.size();
                for (int i = 0; i < isz; ++i) {
                    newIDList.add(((Annotation)newAnnotationList.get(i)).getId());
                }
                cloneResponseElement = this.buildMap(oldIDList.toArray(new Long[0]), newIDList.toArray(new Long[0]));
                Annotation annotation = new Annotation();
                annotation.setParentId(sourceParentID);
                annotation.setSecondaryParentId(sourceSecondaryParentID);
                AnnotationLogger.getInstance().logUserRequest("READ", this.getRequest(), annotation);
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return cloneResponseElement;
    }

    private Annotation clone(Annotation source, String parentID, String secondaryParentID) {
        Annotation target = new Annotation();
        target.setContext(source.getContext());
        target.setCreationTime(source.getCreationTime());
        target.getText().setDescription(source.getText().getDescription());
        target.setLastModificationTime(source.getLastModificationTime());
        target.setLocale(source.getLocale());
        target.getText().setName(source.getText().getName());
        target.setOwner(source.getOwner());
        target.setParentId(parentID);
        target.setSecondaryParentId(secondaryParentID);
        List<AnnotationProperty> annPropertyList = source.getProperties();
        for (AnnotationProperty sourceProp : annPropertyList) {
            AnnotationProperty cloneProp = new AnnotationProperty();
            cloneProp.setName(sourceProp.getName());
            cloneProp.setValue(sourceProp.getValue());
            target.addProperty(cloneProp);
            cloneProp.setAnnotation(target);
        }
        return target;
    }

    private Element buildMap(Long[] oldIDs, Long[] newIDs) {
        Document document = DocumentHelper.createDocument();
        Element annotationMapElement = document.addElement(XMLSOAPHelper.ANNOTATION_MAP);
        for (int i = 0; i < oldIDs.length; ++i) {
            long oldID = oldIDs[i];
            long newID = newIDs[i];
            Element annotationMapEntryElement = annotationMapElement.addElement(XMLSOAPHelper.ANNOTATION_MAP_ENTRY);
            Element oldIDElement = annotationMapEntryElement.addElement(XMLSOAPHelper.ANNOTATION_OLD_ID);
            oldIDElement.setText("" + oldID);
            Element newIDElement = annotationMapEntryElement.addElement(XMLSOAPHelper.ANNOTATION_NEW_ID);
            newIDElement.setText("" + newID);
        }
        return (Element)annotationMapElement.detach();
    }

    protected PersistorContext getPersistorContext(EntityManager em) {
        return new PersistorContextImpl(this.getResources().getQueryFactory(), em);
    }
}

