/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.convert.deserialize.Deserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.DeserializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.persist.PersistResult;
import com.ibm.cognos.internal.annotations.persist.Persistor;
import com.ibm.cognos.internal.annotations.persist.PersistorContext;
import com.ibm.cognos.internal.annotations.persist.PersistorContextImpl;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import com.ibm.cognos.internal.annotations.users.MultiCMProperties;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.persistence.EntityManager;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CreateAnnotationCommand
extends AnnotationCommand {
    public CreateAnnotationCommand(MessageContext mc, AnnotationResources resources) {
        super(mc, resources);
    }

    @Override
    public RestResponse performRestAction(String sourceID) throws AnnotationServiceException {
        String annotationNameFormValue = this.getRequest().getFormValue("annotationName");
        if (annotationNameFormValue == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.NAME_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        String annotationDescriptionFormValue = this.getRequest().getFormValue("annotationDescription");
        if (annotationDescriptionFormValue == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.DESCRIPTION_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        String annotationParentID = this.getRequest().getFormValue("annotationParentID");
        if (annotationParentID == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.PARENT_ID_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        Annotation annotation = new Annotation();
        annotation.getText().setName(annotationNameFormValue);
        annotation.getText().setDescription(annotationDescriptionFormValue);
        annotation.setParentId(annotationParentID);
        this.validateDeserializedAnnotation(annotation);
        PersistResult result = this.saveIfPermitted(annotation);
        Document document = DocumentHelper.createDocument();
        Element responseAnnotationElement = document.addElement(XMLSOAPHelper.ANNOTATION_ELEMENT);
        Element annotationIDElement = responseAnnotationElement.addElement(XMLSOAPHelper.ANNOTATION_ID);
        annotationIDElement.setText("" + ((Annotation)result.getPersistedObject()).getId());
        return new RestResponse(responseAnnotationElement.asXML(), "text/xml");
    }

    @Override
    public Element performSoapAction() throws AnnotationServiceException {
        Element annotationElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_ELEMENT);
        this.validateInputAnnotation(annotationElement);
        DeserializerFactory factory = this.getResources().getDeserializerFactory();
        Deserializer pojoBuilder = factory.getDeserializer(annotationElement);
        Annotation convertedAnnotation = (Annotation)pojoBuilder.convert();
        this.validateDeserializedAnnotation(convertedAnnotation);
        PersistResult result = this.saveIfPermitted(convertedAnnotation);
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_CREATE_RESPONSE);
        Element responseAnnotationElement = responseElement.addElement(XMLSOAPHelper.ANNOTATION_ELEMENT);
        Element annotationIDElement = responseAnnotationElement.addElement(XMLSOAPHelper.ANNOTATION_ID);
        annotationIDElement.setText("" + ((Annotation)result.getPersistedObject()).getId());
        responseElement.detach();
        return responseElement;
    }

    private PersistResult saveIfPermitted(Annotation annotation) throws AnnotationServiceException {
        if (annotation.getLocale() == null) {
            BiBusHeader header = BiBusUtilities.retrieveHeader((BIBusEnvelope)this.getRequest());
            annotation.setLocale(LocaleUtil.getRequestContentLocale((BiBusHeader)header));
        }
        CMProperties parentCMProps = this.getCMProperties(annotation.getParentId());
        CMProperties secondaryParentCMProps = null;
        if (annotation.getSecondaryParentId() != null) {
            secondaryParentCMProps = this.getCMProperties(annotation.getSecondaryParentId());
        }
        MultiCMProperties multiRequest = annotation.getSecondaryParentId() == null ? this.getMultiCMPropertiesRequest(new CMProperties[]{parentCMProps}) : this.getMultiCMPropertiesRequest(new CMProperties[]{parentCMProps, secondaryParentCMProps});
        multiRequest.getCMInfo();
        if (!parentCMProps.exists()) {
            throw new AnnotationServiceException(AnnotationI18NCode.INVALID_ANNOTATION_PARENT_ID_REFERENCE, new Object[]{annotation.getParentId()}, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotation.getSecondaryParentId() != null && !secondaryParentCMProps.exists()) {
            throw new AnnotationServiceException(AnnotationI18NCode.INVALID_ANNOTATION_PARENT_ID_REFERENCE, new Object[]{annotation.getSecondaryParentId()}, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        PersistResult result = null;
        if (parentCMProps.readPermission()) {
            int attempt = 0;
            boolean retry = true;
            AnnotationServiceException persistException = null;
            while (retry) {
                ++attempt;
                persistException = null;
                try {
                    result = this.persistAnnotation(annotation);
                    retry = false;
                }
                catch (AnnotationServiceException e) {
                    persistException = e;
                    retry = persistException.isRetryException();
                }
                if (attempt != 2) continue;
                if (persistException != null) {
                    throw persistException;
                }
                retry = false;
            }
        } else {
            throw new AnnotationServiceException(AnnotationI18NCode.NO_PERMISSION_CREATE, new Object[]{annotation.getParentId()}, AnnotationServiceException.FaultType.FORBIDDEN);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistResult persistAnnotation(Annotation convertedAnnotation) throws AnnotationServiceException {
        convertedAnnotation.setCreationTime(new Date());
        convertedAnnotation.setLastModificationTime(new Date());
        CMProperties user = this.getUser();
        user.getCMInfo();
        convertedAnnotation.setOwner(user.getBaseClass().getStoreID().getValue().get_value());
        EntityManager em = null;
        PersistResult result = null;
        try {
            em = this.getResources().getEntityManagerFactory().createEntityManager();
            PersistorContext persistenceContext = this.getPersistorContext(em);
            Persistor annotationPersistor = this.getResources().getPersistorFactory().getPersistor(convertedAnnotation, persistenceContext);
            result = annotationPersistor.persist();
            persistenceContext.persist(result);
            AnnotationLogger.getInstance().logUserRequest("CREATE", this.getRequest(), convertedAnnotation);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return result;
    }

    private void validateInputAnnotation(Element annotationElement) throws AnnotationServiceException {
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_ID) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ID_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_CREATIONTIME) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.CREATION_TIME_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_LASTMODTIME) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.LAST_MOD_TIME_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_OWNER) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.OWNER_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID) == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.PARENT_ID_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_NAME) == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.NAME_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_DESCRIPTION) == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.DESCRIPTION_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
    }

    private void validateDeserializedAnnotation(Annotation annotation) throws AnnotationServiceException {
        String description = annotation.getText().getDescription();
        if (description != null) {
            byte[] descriptionBytes = null;
            try {
                descriptionBytes = description.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (descriptionBytes.length > 3100) {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_DESCRIPTION_TOO_LARGE, new Object[]{"" + descriptionBytes.length});
            }
        }
    }

    protected PersistorContext getPersistorContext(EntityManager em) {
        return new PersistorContextImpl(this.getResources().getQueryFactory(), em);
    }
}

