/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DeleteAnnotationCommand
extends AnnotationCommand {
    public static boolean BUX = true;

    public DeleteAnnotationCommand(MessageContext mc, AnnotationResources resources) {
        super(mc, resources);
    }

    @Override
    public RestResponse performRestAction(String sourceID) throws AnnotationServiceException {
        String annotationsFormValue = this.getRequest().getFormValue("annotations");
        if (annotationsFormValue == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.DELETION_LIST_NOT_FOUND);
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        StringTokenizer tokenizer = new StringTokenizer(annotationsFormValue, ":");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            idList.add(Long.parseLong(token));
        }
        CMProperties user = this.getUser();
        user.getCMInfo();
        BaseClass account = user.getBaseClass();
        int deleted = this.deleteAnnotationByIdList(idList, account);
        Document document = DocumentHelper.createDocument();
        Element deleteCountElement = document.addElement(XMLSOAPHelper.ANN_DELETED_ELEMENT);
        deleteCountElement.addText("" + deleted);
        deleteCountElement.detach();
        RestResponse restResponse = new RestResponse(deleteCountElement.asXML(), "text/xml");
        return restResponse;
    }

    @Override
    public Element performSoapAction() throws AnnotationServiceException {
        CMProperties user = this.getUser();
        user.getCMInfo();
        BaseClass account = user.getBaseClass();
        Element responseElement = null;
        Element operationElement = this.getOperationElement();
        if (operationElement.getQName().equals((Object)XMLSOAPHelper.ANN_DELETE_BY_ID_REQUEST)) {
            responseElement = this.deleteById(account);
        } else if (operationElement.getQName().equals((Object)XMLSOAPHelper.ANN_DELETE_BY_PARENT_ID_REQUEST)) {
            responseElement = this.deleteByParentId(account);
        }
        return responseElement;
    }

    private Element deleteById(BaseClass owner) throws AnnotationServiceException {
        String idElement = this.getSingleId();
        int deleteCount = this.deleteAnnotationById(Long.parseLong(idElement), owner);
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_DELETE_BY_ID_RESPONSE);
        Element deleteCountElement = responseElement.addElement(XMLSOAPHelper.ANN_DELETED_ELEMENT);
        deleteCountElement.addText("" + deleteCount);
        responseElement.detach();
        return responseElement;
    }

    private String getSingleId() throws AnnotationServiceException {
        Element idElement = null;
        Element annotationElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_ELEMENT);
        if (annotationElement != null) {
            idElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_ID);
        }
        if (idElement == null || idElement.getText() == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        return idElement.getText();
    }

    private Element deleteByParentId(BaseClass owner) throws AnnotationServiceException {
        String parentId = this.getSingleParentId();
        Element responseElement = null;
        int deleted = this.deleteAnnotationByParentId(parentId, owner);
        Document document = DocumentHelper.createDocument();
        responseElement = document.addElement(XMLSOAPHelper.ANN_DELETE_BY_PARENT_ID_RESPONSE);
        Element deleteCountElement = responseElement.addElement(XMLSOAPHelper.ANN_DELETED_ELEMENT);
        deleteCountElement.addText("" + deleted);
        responseElement.detach();
        return responseElement;
    }

    private String getSingleParentId() throws AnnotationServiceException {
        Element parentIdElement = null;
        Element annotationElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_ELEMENT);
        if (annotationElement != null) {
            parentIdElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID);
        }
        if (parentIdElement == null || parentIdElement.getText() == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_PARENT_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        return parentIdElement.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteAnnotationById(Long id, BaseClass owner) throws AnnotationServiceException {
        EntityManager em = null;
        int deleted = 0;
        em = this.getResources().getEntityManagerFactory().createEntityManager();
        try {
            Annotation annotation = (Annotation)em.find(Annotation.class, (Object)id);
            if (annotation == null) {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_NOT_FOUND, new Object[]{"" + id}, AnnotationServiceException.FaultType.NO_OBJECT);
            }
            CMProperties cmProps = this.getCMProperties(annotation.getParentId());
            cmProps.getCMInfo();
            if (!cmProps.readPermission()) {
                throw new AnnotationServiceException(AnnotationI18NCode.NO_PERMISSION_DELETE, new Object[]{annotation.getParentId()}, AnnotationServiceException.FaultType.REQUEST_ERROR);
            }
            EntityTransaction transaction = em.getTransaction();
            try {
                transaction.begin();
                AnnotationDAO annotationDAO = this.getResources().getDAOFactory().buildDAO(AnnotationDAO.class);
                deleted = BUX ? annotationDAO.deleteAnnotationByID(em, id).executeUpdate() : annotationDAO.deleteAnnotationByIDWithMatchingOwner(em, id, owner.getStoreID().getValue().get_value()).executeUpdate();
                transaction.commit();
                AnnotationLogger.getInstance().logUserRequest("DELETE", this.getRequest(), annotation);
            }
            catch (Throwable t) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                if (t instanceof AnnotationServiceException) {
                    throw (AnnotationServiceException)t;
                }
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteAnnotationByParentId(String parentId, BaseClass owner) throws AnnotationServiceException {
        int deleted = 0;
        EntityManager em = this.getResources().getEntityManagerFactory().createEntityManager();
        try {
            CMProperties parentCMProps = this.getCMProperties(parentId);
            parentCMProps.getCMInfo();
            if (!parentCMProps.readPermission()) {
                throw new AnnotationServiceException(AnnotationI18NCode.NO_PERMISSION_DELETE, new Object[]{parentId}, AnnotationServiceException.FaultType.REQUEST_ERROR);
            }
            EntityTransaction transaction = em.getTransaction();
            try {
                transaction.begin();
                AnnotationDAO annotationDAO = this.getResources().getDAOFactory().buildDAO(AnnotationDAO.class);
                deleted = BUX ? annotationDAO.deleteAnnotationByParentIDs(em, parentId, null).executeUpdate() : annotationDAO.deleteAnnotationByParentIDWithMatchingOwner(em, parentId, owner.getStoreID().getValue().get_value()).executeUpdate();
                Annotation annotation = new Annotation();
                annotation.setOwner(owner.getStoreID().getValue().get_value());
                annotation.setParentId(parentId);
                AnnotationLogger.getInstance().logUserRequest("DELETE", this.getRequest(), annotation);
                transaction.commit();
            }
            catch (Throwable t) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                if (t instanceof AnnotationServiceException) {
                    throw (AnnotationServiceException)t;
                }
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteAnnotationByIdList(List<Long> idList, BaseClass owner) throws AnnotationServiceException {
        EntityManager em = null;
        int deleted = 0;
        em = this.getResources().getEntityManagerFactory().createEntityManager();
        try {
            AnnotationDAO annotationDAO = this.getResources().getDAOFactory().buildDAO(AnnotationDAO.class);
            Query query = annotationDAO.findAnnotationsGivenIDs(em, idList);
            Hashtable<String, CMProperties> foundParents = new Hashtable<String, CMProperties>();
            List annotations = query.getResultList();
            for (Annotation annotation : annotations) {
                String parentId = annotation.getParentId();
                CMProperties properties = (CMProperties)foundParents.get(parentId);
                if (properties == null) {
                    properties = this.getCMProperties(parentId);
                    properties.getCMInfo();
                    foundParents.put(parentId, properties);
                }
                if (properties.readPermission()) continue;
                throw new AnnotationServiceException(AnnotationI18NCode.NO_PERMISSION_DELETE, new Object[]{parentId}, AnnotationServiceException.FaultType.FORBIDDEN);
            }
            EntityTransaction transaction = em.getTransaction();
            try {
                transaction.begin();
                deleted = BUX ? annotationDAO.deleteAnnotationByIDList(em, idList).executeUpdate() : annotationDAO.deleteAnnotationByIDListWithMatchingOwner(em, idList, owner.getStoreID().getValue().get_value()).executeUpdate();
                transaction.commit();
            }
            catch (Throwable t) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                if (t instanceof AnnotationServiceException) {
                    throw (AnnotationServiceException)t;
                }
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return deleted;
    }
}

