/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.convert.serialize.Serializer;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerContextImpl;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerFactory;
import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import com.ibm.cognos.internal.annotations.users.MultiCMProperties;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ReadAnnotationCommand
extends AnnotationCommand {
    public ReadAnnotationCommand(MessageContext mc, AnnotationResources resources) {
        super(mc, resources);
    }

    @Override
    public RestResponse performRestAction(String sourceID) throws AnnotationServiceException {
        Element annotationResponseElement = null;
        String pathInfo = (String)this.getMessageContext().getProperty("path_info");
        String[] parts = pathInfo.split("/");
        String resource_type = parts[2];
        if (resource_type.equals("annotation")) {
            if (sourceID.equals("parentID")) {
                String parentID = parts[4];
                if (parentID != null) {
                    annotationResponseElement = this.findAnnotationsByParentID(parentID);
                }
            } else {
                annotationResponseElement = this.findAnnotationById(Long.parseLong(sourceID));
            }
        } else if (resource_type.equals("annotationList")) {
            annotationResponseElement = this.findAnnotationByList(sourceID);
        }
        return new RestResponse(annotationResponseElement.asXML(), "text/xml");
    }

    @Override
    public Element performSoapAction() throws AnnotationServiceException {
        Element responseElement = null;
        Element operationElement = this.getOperationElement();
        if (operationElement.getQName().equals((Object)XMLSOAPHelper.ANN_READ_BY_ID_REQUEST)) {
            responseElement = this.readById();
        } else if (operationElement.getQName().equals((Object)XMLSOAPHelper.ANN_READ_BY_PARENT_ID_REQUEST)) {
            responseElement = this.readByParentId();
        }
        return responseElement;
    }

    private Element readById() throws AnnotationServiceException {
        Element idElement = null;
        Element annotationElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_ELEMENT);
        if (annotationElement != null) {
            idElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_ID);
        }
        if (idElement == null || idElement.getText() == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        Element annotationResponseElement = this.findAnnotationById(Long.parseLong(idElement.getText()));
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_READ_BY_ID_RESPONSE);
        if (annotationResponseElement != null) {
            responseElement.add(annotationResponseElement);
        }
        responseElement.detach();
        return responseElement;
    }

    private Element findAnnotationByList(String sourceID) throws AnnotationServiceException {
        ArrayList<Long> idList = new ArrayList<Long>();
        StringTokenizer tokenizer = new StringTokenizer(sourceID, ":");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            idList.add(Long.parseLong(token));
        }
        return this.findAnnotationByIdList(idList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element findAnnotationByIdList(List<Long> idList) throws AnnotationServiceException {
        EntityManager em = null;
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_ANNOTATIONS_ELEMENT);
        em = this.getResources().getEntityManagerFactory().createEntityManager();
        try {
            AnnotationDAO annotationDAO = this.getResources().getDAOFactory().buildDAO(AnnotationDAO.class);
            List queryResults = annotationDAO.findAnnotationsGivenIDs(em, idList).getResultList();
            SerializerFactory factory = this.getResources().getSerializerFactory();
            for (Annotation annotation : queryResults) {
                CMProperties parentCMProps = this.getCMProperties(annotation.getParentId());
                CMProperties ownerCMProps = this.getCMProperties(annotation.getOwner());
                CMProperties secondaryParentCMProps = null;
                if (annotation.getSecondaryParentId() != null) {
                    secondaryParentCMProps = this.getCMProperties(annotation.getSecondaryParentId());
                }
                MultiCMProperties multiRequest = annotation.getSecondaryParentId() == null ? this.getMultiCMPropertiesRequest(new CMProperties[]{parentCMProps, ownerCMProps}) : this.getMultiCMPropertiesRequest(new CMProperties[]{parentCMProps, secondaryParentCMProps, ownerCMProps});
                multiRequest.getCMInfo();
                if (parentCMProps.readPermission()) {
                    Serializer annotationBuilder = factory.getSerializer(annotation, new SerializerContextImpl(this.getRequest()));
                    Element annotationResponseElement = annotationBuilder.convert();
                    this.buildCMRefs(annotationResponseElement, parentCMProps, secondaryParentCMProps, ownerCMProps);
                    responseElement.add(annotationResponseElement);
                }
                AnnotationLogger.getInstance().logUserRequest("READ", this.getRequest(), annotation);
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return (Element)responseElement.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element findAnnotationsByParentID(String parentID) throws AnnotationServiceException {
        Document document = DocumentHelper.createDocument();
        Element annotationsElement = document.addElement(XMLSOAPHelper.ANN_ANNOTATIONS_ELEMENT);
        EntityManager em = this.getResources().getEntityManagerFactory().createEntityManager();
        try {
            CMProperties parentCMProps = this.getCMProperties(parentID);
            parentCMProps.getCMInfo();
            Hashtable<String, CMProperties> ownerPropertiesMap = new Hashtable<String, CMProperties>();
            Hashtable<String, CMProperties> secondaryParentMap = new Hashtable<String, CMProperties>();
            if (!parentCMProps.exists()) {
                throw new AnnotationServiceException(AnnotationI18NCode.INVALID_ANNOTATION_PARENT_ID_REFERENCE, new Object[]{parentID}, AnnotationServiceException.FaultType.REQUEST_ERROR);
            }
            if (parentCMProps.readPermission()) {
                Annotation annotation2;
                AnnotationDAO annotationDAO = this.getResources().getDAOFactory().buildDAO(AnnotationDAO.class);
                List queryResults = annotationDAO.findAnnotationsByParentIDs(em, parentID, null).getResultList();
                SerializerFactory factory = this.getResources().getSerializerFactory();
                for (Annotation annotation2 : queryResults) {
                    CMProperties ownerCMProps = null;
                    if (ownerPropertiesMap.containsKey(annotation2.getOwner())) {
                        ownerCMProps = (CMProperties)ownerPropertiesMap.get(annotation2.getOwner());
                    } else {
                        ownerCMProps = this.getCMProperties(annotation2.getOwner());
                        ownerCMProps.getCMInfo();
                        ownerPropertiesMap.put(annotation2.getOwner(), ownerCMProps);
                    }
                    CMProperties secondaryCMProps = null;
                    if (annotation2.getSecondaryParentId() != null) {
                        if (secondaryParentMap.containsKey(annotation2.getSecondaryParentId())) {
                            secondaryCMProps = (CMProperties)secondaryParentMap.get(annotation2.getSecondaryParentId());
                        } else {
                            secondaryCMProps = this.getCMProperties(annotation2.getSecondaryParentId());
                            secondaryCMProps.getCMInfo();
                            secondaryParentMap.put(annotation2.getSecondaryParentId(), secondaryCMProps);
                        }
                    }
                    Serializer annotationBuilder = factory.getSerializer(annotation2, new SerializerContextImpl(this.getRequest()));
                    Element annotationResponseElement = annotationBuilder.convert();
                    annotationsElement.add(annotationResponseElement);
                    this.buildCMRefs(annotationResponseElement, parentCMProps, secondaryCMProps, ownerCMProps);
                }
                annotation2 = new Annotation();
                annotation2.setParentId(parentID);
                AnnotationLogger.getInstance().logUserRequest("READ", this.getRequest(), annotation2);
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return (Element)annotationsElement.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element findAnnotationById(Long id) throws AnnotationServiceException {
        Element annotationResponseElement = null;
        EntityManager em = null;
        try {
            em = this.getResources().getEntityManagerFactory().createEntityManager();
            Annotation annotation = (Annotation)em.find(Annotation.class, (Object)id);
            if (annotation == null) {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_NOT_FOUND, new Object[]{id.toString()}, AnnotationServiceException.FaultType.NO_OBJECT);
            }
            CMProperties parentCMProps = this.getCMProperties(annotation.getParentId());
            CMProperties ownerCMProps = this.getCMProperties(annotation.getOwner());
            CMProperties secondaryParentCMProps = null;
            if (annotation.getSecondaryParentId() != null) {
                secondaryParentCMProps = this.getCMProperties(annotation.getSecondaryParentId());
            }
            MultiCMProperties multiRequest = annotation.getSecondaryParentId() == null ? this.getMultiCMPropertiesRequest(new CMProperties[]{parentCMProps, ownerCMProps}) : this.getMultiCMPropertiesRequest(new CMProperties[]{parentCMProps, secondaryParentCMProps, ownerCMProps});
            multiRequest.getCMInfo();
            if (parentCMProps.readPermission()) {
                SerializerFactory factory = this.getResources().getSerializerFactory();
                Serializer annotationBuilder = factory.getSerializer(annotation, new SerializerContextImpl(this.getRequest()));
                annotationResponseElement = annotationBuilder.convert();
                this.buildCMRefs(annotationResponseElement, parentCMProps, secondaryParentCMProps, ownerCMProps);
            }
            AnnotationLogger.getInstance().logUserRequest("READ", this.getRequest(), annotation);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return annotationResponseElement;
    }

    private Element readByParentId() throws AnnotationServiceException {
        Element parentIdElement = null;
        Element annotationElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_ELEMENT);
        if (annotationElement != null) {
            parentIdElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID);
        }
        if (parentIdElement == null || parentIdElement.getText() == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_PARENT_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_READ_BY_PARENT_ID_RESPONSE);
        Element annotationResponseElement = this.findAnnotationsByParentID(parentIdElement.getText());
        responseElement.add(annotationResponseElement);
        return responseElement;
    }

    private void buildCMRefs(Element annotationElement, CMProperties parentCMProps, CMProperties secondaryParentCMProps, CMProperties ownerCMProps) {
        Element parentElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID);
        Element ownerElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_OWNER);
        Element secondaryParentElement = annotationElement.element(XMLSOAPHelper.ANNOTATION_SECONDARY_PARENTID);
        parentElement.clearContent();
        parentElement.add(parentCMProps.getCMRef());
        ownerElement.clearContent();
        ownerElement.add(ownerCMProps.getCMRef());
        if (secondaryParentCMProps != null) {
            secondaryParentElement.clearContent();
            secondaryParentElement.add(secondaryParentCMProps.getCMRef());
        }
    }
}

