/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.convert.deserialize.Deserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.DeserializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.annotations.users.CMProperties;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class UpdateAnnotationCommand
extends AnnotationCommand {
    public UpdateAnnotationCommand(MessageContext mc, AnnotationResources resources) {
        super(mc, resources);
    }

    @Override
    public RestResponse performRestAction(String sourceID) throws AnnotationServiceException {
        Annotation convertedAnnotation = new Annotation();
        String annotationNameFormValue = this.getRequest().getFormValue("annotationName");
        if (annotationNameFormValue == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.NAME_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        String annotationDescriptionFormValue = this.getRequest().getFormValue("annotationDescription");
        if (annotationDescriptionFormValue == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.DESCRIPTION_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        convertedAnnotation.setId(Long.parseLong(sourceID));
        convertedAnnotation.getText().setName(annotationNameFormValue);
        convertedAnnotation.getText().setDescription(annotationDescriptionFormValue);
        convertedAnnotation.setCreationTime(new Date());
        convertedAnnotation.setLastModificationTime(new Date());
        this.validateDeserializedAnnotation(convertedAnnotation);
        Annotation annotation = this.executeUpdateAnnotation(convertedAnnotation);
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_UPDATE_RESPONSE);
        Element responseAnnotationElement = this.buildUpdateAnnotationResponse(annotation, responseElement);
        responseAnnotationElement.detach();
        return new RestResponse(responseAnnotationElement.asXML(), "text/xml");
    }

    @Override
    public Element performSoapAction() throws AnnotationServiceException {
        Element annotationElement = this.getOperationElement().element(XMLSOAPHelper.ANNOTATION_ELEMENT);
        this.validateInputAnnotation(annotationElement);
        DeserializerFactory factory = this.getResources().getDeserializerFactory();
        Deserializer pojoBuilder = factory.getDeserializer(annotationElement);
        Annotation convertedAnnotation = (Annotation)pojoBuilder.convert();
        this.validateDeserializedAnnotation(convertedAnnotation);
        Annotation annotation = this.executeUpdateAnnotation(convertedAnnotation);
        Document document = DocumentHelper.createDocument();
        Element responseElement = document.addElement(XMLSOAPHelper.ANN_UPDATE_RESPONSE);
        Element responseAnnotationElement = this.buildUpdateAnnotationResponse(annotation, responseElement);
        responseElement.detach();
        return responseElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Annotation executeUpdateAnnotation(Annotation convertedAnnotation) throws AnnotationServiceException {
        convertedAnnotation.setCreationTime(new Date());
        convertedAnnotation.setLastModificationTime(new Date());
        CMProperties user = this.getUser();
        user.getCMInfo();
        BaseClass account = user.getBaseClass();
        convertedAnnotation.setOwner(account.getStoreID().getValue().get_value());
        EntityManager em = null;
        Annotation annotation = null;
        try {
            em = this.getResources().getEntityManagerFactory().createEntityManager();
            annotation = (Annotation)em.find(Annotation.class, (Object)convertedAnnotation.getId());
            if (annotation == null) {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_NOT_FOUND, new Object[]{"" + convertedAnnotation.getId()}, AnnotationServiceException.FaultType.NO_OBJECT);
            }
            CMProperties parentCMProps = this.getCMProperties(annotation.getParentId());
            parentCMProps.getCMInfo();
            if (!parentCMProps.readPermission()) {
                throw new AnnotationServiceException(AnnotationI18NCode.NO_PERMISSION_UPDATE, new Object[]{annotation.getParentId()}, AnnotationServiceException.FaultType.FORBIDDEN);
            }
            if (!annotation.getOwner().equals(convertedAnnotation.getOwner())) {
                throw new AnnotationServiceException(AnnotationI18NCode.NOT_OWNER, AnnotationServiceException.FaultType.FORBIDDEN);
            }
            EntityTransaction transaction = em.getTransaction();
            try {
                transaction.begin();
                annotation.getText().setName(convertedAnnotation.getText().getName());
                annotation.getText().setDescription(convertedAnnotation.getText().getDescription());
                annotation.setLastModificationTime(convertedAnnotation.getLastModificationTime());
                transaction.commit();
                AnnotationLogger.getInstance().logUserRequest("UPDATE", this.getRequest(), annotation);
            }
            catch (Throwable t) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                if (t instanceof AnnotationServiceException) {
                    throw (AnnotationServiceException)t;
                }
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_GENERAL_ERROR, t);
            }
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        return annotation;
    }

    private void validateInputAnnotation(Element annotationElement) throws AnnotationServiceException {
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_ID) == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_ID_NOT_FOUND, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_CREATIONTIME) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.CREATION_TIME_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_LASTMODTIME) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.LAST_MOD_TIME_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_OWNER) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.OWNER_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_CONTEXT) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.CONTEXT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_PARENTID) != null) {
            throw new AnnotationServiceException(AnnotationI18NCode.PARENT_ID_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_NAME) == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.NAME_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
        if (annotationElement.element(XMLSOAPHelper.ANNOTATION_DESCRIPTION) == null) {
            throw new AnnotationServiceException(AnnotationI18NCode.DESCRIPTION_NOT_INCLUDED_INCORRECT, AnnotationServiceException.FaultType.REQUEST_ERROR);
        }
    }

    private void validateDeserializedAnnotation(Annotation annotation) throws AnnotationServiceException {
        String description = annotation.getText().getDescription();
        if (description != null) {
            byte[] descriptionBytes = null;
            try {
                descriptionBytes = description.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (descriptionBytes.length > 3100) {
                throw new AnnotationServiceException(AnnotationI18NCode.ANNOTATION_DESCRIPTION_TOO_LARGE, new Object[]{"" + descriptionBytes.length});
            }
        }
    }

    private Element buildUpdateAnnotationResponse(Annotation annotation, Element rootElement) {
        Element responseAnnotationElement = rootElement.addElement(XMLSOAPHelper.ANNOTATION_ELEMENT);
        Element idElement = responseAnnotationElement.addElement(XMLSOAPHelper.ANNOTATION_ID);
        idElement.addText("" + annotation.getId());
        Element lastModElement = responseAnnotationElement.addElement(XMLSOAPHelper.ANNOTATION_LASTMODTIME);
        lastModElement.setText(XMLSOAPHelper.dateTimeFormat.format(annotation.getLastModificationTime()));
        String timeZone = this.getRequest().getUserPreferenceValue("timeZoneID");
        String contentLocale = this.getRequest().getUserPreferenceValue("contentLocale");
        String lastModTimeFormatted = TimeUtils.getUserTZFormattedTime((Long)annotation.getLastModificationTime().getTime(), timeZone, new Locale(contentLocale));
        Element lastModFormattedElement = responseAnnotationElement.addElement(XMLSOAPHelper.ANNOTATION_LASTMODTIMEFORMATTED);
        lastModFormattedElement.setText(lastModTimeFormatted);
        return responseAnnotationElement;
    }
}

