/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.commands;

import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.annotations.commands.AnnotationCommand;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.service.AnnotationResources;
import com.ibm.cognos.internal.annotations.service.RestResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.dom4j.Element;

public class WSDLCommand
extends AnnotationCommand {
    private static final String SDK_ENDPOINT = "@@SDK_ENDPOINT@@";
    private static final String WSDL_NAME = "annotationService.wsdl";
    private static HashMap<String, byte[]> dataMap = new HashMap();

    public WSDLCommand(MessageContext mc, AnnotationResources resources) {
        super(mc, resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestResponse performRestAction(String sourceID) throws AnnotationServiceException {
        String gatewayLocation = null;
        try {
            gatewayLocation = this.getResources().getConfiguration().getProperty("gateway");
        }
        catch (PropertiesException e) {
            throw new AnnotationServiceException(AnnotationI18NCode.CANNOT_GET_GATEWAY);
        }
        byte[] content = null;
        String resource = WSDL_NAME;
        WSDLCommand wSDLCommand = this;
        synchronized (wSDLCommand) {
            try {
                content = dataMap.get(resource);
                if (content == null) {
                    content = this.getContent(resource);
                    String temp = new String(content, "UTF-8");
                    temp = this.replaceEndpoint(temp, SDK_ENDPOINT, gatewayLocation);
                    content = temp.getBytes("UTF-8");
                    dataMap.put(resource, content);
                }
            }
            catch (IOException ex) {
                throw new AnnotationServiceException(AnnotationI18NCode.CANNOT_READ_RESOURCE, new Object[]{resource}, ex);
            }
            if (content == null) {
                throw new AnnotationServiceException(AnnotationI18NCode.CANNOT_READ_RESOURCE, new Object[]{resource});
            }
        }
        return new RestResponse(new ByteArrayInputStream(content), "text/xml");
    }

    @Override
    public Element performSoapAction() throws AnnotationServiceException {
        throw new AnnotationServiceException(AnnotationI18NCode.NOT_IMPLEMENTED);
    }

    private String replaceEndpoint(String rawWSDL, String marker, String endpoint) {
        int currentMatch = rawWSDL.indexOf(marker);
        if (currentMatch == -1) {
            return rawWSDL;
        }
        int markerLength = marker.length();
        int currentStringPosition = 0;
        StringBuffer strBuf = new StringBuffer();
        while (currentMatch != -1) {
            strBuf.append(rawWSDL.substring(currentStringPosition, currentMatch));
            strBuf.append(endpoint);
            currentStringPosition = currentMatch + markerLength;
            currentMatch = rawWSDL.indexOf(marker, currentStringPosition);
        }
        int rawWSDLLength = rawWSDL.length();
        if (currentStringPosition < rawWSDLLength) {
            strBuf.append(rawWSDL.substring(currentStringPosition, rawWSDLLength));
        }
        return strBuf.toString();
    }

    private byte[] getContent(String wsdl) throws IOException {
        DataInputStream inStream = new DataInputStream(this.getClass().getClassLoader().getResourceAsStream(wsdl));
        if (inStream == null) {
            throw new IOException();
        }
        int bytesAvailable = inStream.available();
        byte[] data = new byte[bytesAvailable];
        inStream.readFully(data);
        return data;
    }
}

