/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.deserialize;

import com.ibm.cognos.internal.annotations.convert.deserialize.Deserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.DeserializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.i18n.MessageResourceProvider;
import com.ibm.cognos.internal.annotations.i18n.MessageResources;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.pojos.AnnotationProperty;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationLoggerProvider;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.Node;

public class AnnotationDeserializer
implements Deserializer {
    private Node annotationNode;
    private DeserializerFactory factory;

    public AnnotationDeserializer(Node annotationNode, DeserializerFactory factory) {
        this.annotationNode = annotationNode;
        this.factory = factory;
    }

    @Override
    public Object convert() throws AnnotationServiceException {
        Node selectionNode;
        Annotation annotation = new Annotation();
        Element idNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_ID);
        Element createTimeNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_CREATIONTIME);
        Element descriptionNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_DESCRIPTION);
        Element lastModNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_LASTMODTIME);
        Element nameNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_NAME);
        Element ownerNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_OWNER);
        Element parentIdNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_PARENTID);
        Element secondaryParentIdNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_SECONDARY_PARENTID);
        Element localeNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_LOCALE);
        Element contextNode = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_CONTEXT);
        Element parameterValues = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_PARAMETERVALUES);
        Element sliderDescription = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_SLIDERDESCRIPTION);
        Element filterDescription = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_FILTERDESCRIPTION);
        Element tags = ((Element)this.annotationNode).element(XMLSOAPHelper.ANNOTATION_TAGS);
        if (idNode != null) {
            annotation.setId(Long.parseLong(idNode.getText()));
        }
        if (createTimeNode != null) {
            try {
                annotation.setCreationTime(XMLSOAPHelper.dateTimeFormat.parse(createTimeNode.getText()));
            }
            catch (ParseException e) {
                throw new AnnotationServiceException(AnnotationI18NCode.INVALID_CREATION_TIME_FORMAT, new Object[]{createTimeNode.getText()}, AnnotationServiceException.FaultType.REQUEST_ERROR);
            }
        }
        if (descriptionNode != null) {
            annotation.getText().setDescription(descriptionNode.getText());
        }
        if (lastModNode != null) {
            try {
                annotation.setLastModificationTime(XMLSOAPHelper.dateTimeFormat.parse(lastModNode.getText()));
            }
            catch (ParseException e) {
                throw new AnnotationServiceException(AnnotationI18NCode.INVALID_LAST_MOD_TIME_FORMAT, new Object[]{lastModNode.getText()}, AnnotationServiceException.FaultType.REQUEST_ERROR);
            }
        }
        if (nameNode != null) {
            annotation.getText().setName(nameNode.getText());
        }
        if (ownerNode != null) {
            annotation.setOwner(ownerNode.getText());
        }
        if (parentIdNode != null) {
            annotation.setParentId(parentIdNode.getText());
        }
        if (secondaryParentIdNode != null) {
            annotation.setSecondaryParentId(secondaryParentIdNode.getText());
        }
        if (localeNode != null) {
            annotation.setLocale(new Locale(localeNode.getText()));
        }
        if (contextNode != null && (selectionNode = contextNode.selectSingleNode("./selections")) != null) {
            Deserializer selectionSpecBuilder = this.factory.getDeserializer((Element)selectionNode);
            Context context = (Context)selectionSpecBuilder.convert();
            if (context.getDimensionMembers().size() > 0) {
                annotation.setContext(context);
            } else {
                AnnotationLoggerProvider logger = AnnotationLogger.getInstance();
                MessageResourceProvider mess = MessageResources.getInstance();
                logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.IGNORING_EMTPY_ELEMENT, new Object[]{AnnotationI18NCode.CONTEXT_TYPE}), null, null);
            }
        }
        if (parameterValues != null) {
            this.createProperty(annotation, (Node)parameterValues);
        }
        if (sliderDescription != null) {
            this.createProperty(annotation, (Node)sliderDescription);
        }
        if (filterDescription != null) {
            this.createProperty(annotation, (Node)filterDescription);
        }
        if (tags != null) {
            Iterator it = tags.elementIterator(XMLSOAPHelper.ANNOTATION_TAG);
            while (it.hasNext()) {
                Element tagElement = (Element)it.next();
                Element nameElement = tagElement.element(XMLSOAPHelper.ANNOTATION_TAG_NAME);
                Element valueElement = tagElement.element(XMLSOAPHelper.ANNOTATION_TAG_VALUE);
                if (nameElement == null || valueElement == null) continue;
                this.createProperty(annotation, nameElement.getText(), valueElement.getText());
            }
        }
        return annotation;
    }

    private void createProperty(Annotation annotation, Node propertyNode) {
        this.createProperty(annotation, ((Element)propertyNode).getQName().getName(), propertyNode.getText());
    }

    private void createProperty(Annotation annotation, String name, String value) {
        AnnotationProperty paramValuesProperty = new AnnotationProperty();
        paramValuesProperty.setName(name);
        paramValuesProperty.setValue(value);
        annotation.addProperty(paramValuesProperty);
        paramValuesProperty.setAnnotation(annotation);
    }
}

