/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.deserialize;

import com.ibm.cognos.internal.annotations.convert.deserialize.Deserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.DeserializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.i18n.MessageResourceProvider;
import com.ibm.cognos.internal.annotations.i18n.MessageResources;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationLoggerProvider;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class ContextDeserializer
implements Deserializer {
    private Node selections;
    private DeserializerFactory factory;

    public ContextDeserializer(Node selections, DeserializerFactory factory) {
        this.selections = selections;
        this.factory = factory;
    }

    @Override
    public Object convert() throws AnnotationServiceException {
        Element queryElement;
        Element layoutElementId;
        Context context = new Context();
        List rows = this.selections.selectNodes("./*[local-name()='query']/*[local-name()='selection']/*[local-name()='rows']/*[local-name()='row']");
        List columns = this.selections.selectNodes("./*[local-name()='query']/*[local-name()='selection']/*[local-name()='columns']/*[local-name()='column']");
        List measures = this.selections.selectNodes("./*[local-name()='query']/*[local-name()='selection']/*[local-name()='measures']/*[local-name()='measure']");
        List sections = this.selections.selectNodes("./*[local-name()='query']/*[local-name()='selection']/*[local-name()='sections']/*[local-name()='section']");
        if (rows != null) {
            this.addDimensionMembersToContext(rows, context);
        }
        if (columns != null) {
            this.addDimensionMembersToContext(columns, context);
        }
        if (measures != null) {
            this.addDimensionMembersToContext(measures, context);
        }
        if (sections != null) {
            this.addDimensionMembersToContext(sections, context);
        }
        if ((layoutElementId = (Element)this.selections.selectSingleNode("./*[local-name()='query']/*[local-name()='selection']/*[local-name()='layoutElementId']")) != null && layoutElementId.getText() != null && layoutElementId.getText().length() > 0) {
            DataItem dataItem = new DataItem("#text()", layoutElementId.getText());
            MetadataItem metadataItem = new MetadataItem("#local-name()", layoutElementId.getName());
            Dimension layoutElementDimension = new Dimension();
            layoutElementDimension.getMetadataItems().add(metadataItem);
            DimensionMember layoutElementDimensionMember = new DimensionMember();
            layoutElementDimensionMember.getDataItems().add(dataItem);
            layoutElementDimensionMember.setDimension(layoutElementDimension);
            layoutElementDimension.getDimensionMembers().add(layoutElementDimensionMember);
            context.getDimensionMembers().add(layoutElementDimensionMember);
        }
        if ((queryElement = (Element)this.selections.selectSingleNode("./*[local-name()='query']")) != null && queryElement.attribute("name") != null && queryElement.attributeValue("name").length() > 0) {
            DataItem dataItem = new DataItem("#text()", queryElement.attributeValue("name"));
            MetadataItem metadataItem = new MetadataItem("#@local-name()", queryElement.attribute("name").getName());
            Dimension queryElementDimension = new Dimension();
            queryElementDimension.getMetadataItems().add(metadataItem);
            DimensionMember queryElementDimensionMember = new DimensionMember();
            queryElementDimensionMember.getDataItems().add(dataItem);
            queryElementDimensionMember.setDimension(queryElementDimension);
            queryElementDimension.getDimensionMembers().add(queryElementDimensionMember);
            context.getDimensionMembers().add(queryElementDimensionMember);
        }
        return context;
    }

    private void addDimensionMembersToContext(List dimensionNodes, Context context) throws AnnotationServiceException {
        for (Node dimensionNode : dimensionNodes) {
            Deserializer dimensionDeserializer = this.factory.getDeserializer((Element)dimensionNode);
            Dimension dimension = (Dimension)dimensionDeserializer.convert();
            if (dimension.getDimensionMembers().size() <= 0) continue;
            DimensionMember dimensionMember = dimension.getDimensionMembers().get(0);
            if (dimension.getMetadataItems().size() > 0 && dimensionMember.getDataItems().size() > 0) {
                context.getDimensionMembers().add(dimensionMember);
                continue;
            }
            AnnotationLoggerProvider logger = AnnotationLogger.getInstance();
            MessageResourceProvider mess = MessageResources.getInstance();
            logger.logRuntimeDebug(mess.getServerLocaleResMessage(AnnotationI18NCode.IGNORING_EMTPY_ELEMENT, new Object[]{AnnotationI18NCode.DIMMEMBER_TYPE}), null, null);
        }
    }
}

