/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.deserialize;

import com.ibm.cognos.internal.annotations.convert.deserialize.AnnotationDeserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.ContextDeserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.Deserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.DimensionDeserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.DimensionMemberDeserializer;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;

public class DeserializerFactory {
    Hashtable<QName, Class<? extends Deserializer>> deserializerMap = new Hashtable();
    Hashtable<QName, Deserializer> deserializerMapOverrides = new Hashtable();

    public DeserializerFactory() {
        this.deserializerMap.put(XMLSOAPHelper.ANNOTATION_ELEMENT, AnnotationDeserializer.class);
        this.deserializerMap.put(new QName("selections"), ContextDeserializer.class);
        this.deserializerMap.put(new QName("row"), DimensionDeserializer.class);
        this.deserializerMap.put(new QName("column"), DimensionDeserializer.class);
        this.deserializerMap.put(new QName("measure"), DimensionDeserializer.class);
        this.deserializerMap.put(new QName("section"), DimensionDeserializer.class);
        this.deserializerMap.put(new QName("item"), DimensionMemberDeserializer.class);
    }

    public Deserializer getDeserializer(Element element) throws AnnotationServiceException {
        Deserializer deserializer = null;
        Deserializer override = this.deserializerMapOverrides.get(element.getQName());
        if (override != null) {
            deserializer = override;
        } else {
            Class<? extends Deserializer> deserializerClass = this.deserializerMap.get(element.getQName());
            if (deserializerClass != null) {
                try {
                    Constructor<? extends Deserializer> constructor = deserializerClass.getConstructor(Node.class, this.getClass());
                    deserializer = constructor.newInstance(element, this);
                }
                catch (Exception e) {
                    throw new AnnotationServiceException(AnnotationI18NCode.DESERIALIZER_CONSTRUCTOR_ERROR, new Object[]{element.getQName().toString()}, e);
                }
            } else {
                throw new AnnotationServiceException(AnnotationI18NCode.DESERIALIZER_NOT_FOUND, new Object[]{element.getQName().toString()});
            }
        }
        return deserializer;
    }

    public void addDeserializer(String elementName, Class<? extends Deserializer> deserializer) {
        this.deserializerMap.put(new QName(elementName), deserializer);
    }

    public void addDeserializerOverride(String elementName, Deserializer deserializer) {
        this.deserializerMapOverrides.put(new QName(elementName), deserializer);
    }

    public void addDeserializer(QName elementName, Class<? extends Deserializer> deserializer) {
        this.deserializerMap.put(elementName, deserializer);
    }

    public void addDeserializerOverride(QName elementName, Deserializer deserializer) {
        this.deserializerMapOverrides.put(elementName, deserializer);
    }
}

