/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.deserialize;

import com.ibm.cognos.internal.annotations.convert.deserialize.Deserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.DeserializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.i18n.MessageResourceProvider;
import com.ibm.cognos.internal.annotations.i18n.MessageResources;
import com.ibm.cognos.internal.annotations.pojos.Dimension;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationLoggerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class DimensionDeserializer
implements Deserializer {
    private Node selectionDimension;
    private DeserializerFactory factory;

    public DimensionDeserializer(Node selectionDimension, DeserializerFactory factory) {
        this.selectionDimension = selectionDimension;
        this.factory = factory;
    }

    @Override
    public Object convert() throws AnnotationServiceException {
        Node nameElementNode;
        Node selectAllNode;
        ArrayList<MetadataItem> metadataItemList = new ArrayList<MetadataItem>();
        List dimensionAttributes = this.selectionDimension.selectNodes("./@*");
        if (dimensionAttributes != null) {
            Iterator it = dimensionAttributes.iterator();
            while (it.hasNext()) {
                this.appendMetadataItem(metadataItemList, (Node)it.next());
            }
        }
        if ((selectAllNode = this.selectionDimension.selectSingleNode("./*[local-name()='selectAll']")) != null) {
            String elementName = "#./" + selectAllNode.getName();
            String elementValue = selectAllNode.getText();
            this.appendMetadataItem(metadataItemList, elementName, elementValue);
        }
        if ((nameElementNode = this.selectionDimension.selectSingleNode("./*[local-name()='item']/*[local-name()='name']")) != null) {
            this.appendMetadataItem(metadataItemList, nameElementNode);
        }
        String elementName = this.selectionDimension.getName();
        String elementTypeName = "#local-name()";
        this.appendMetadataItem(metadataItemList, elementTypeName, elementName);
        Dimension dimension = new Dimension();
        dimension.getMetadataItems().addAll(metadataItemList);
        Node dimensionMemberNode = this.selectionDimension.selectSingleNode("./*[local-name()='item']/*[local-name()='value']/*[local-name()='item']");
        Deserializer dimensionMemberDeserializer = this.factory.getDeserializer((Element)dimensionMemberNode);
        DimensionMember dimensionMember = (DimensionMember)dimensionMemberDeserializer.convert();
        dimension.getDimensionMembers().add(dimensionMember);
        dimensionMember.setDimension(dimension);
        return dimension;
    }

    private void appendMetadataItem(List<MetadataItem> metadataItemList, Node node) {
        String name = node.getName();
        String value = node.getText();
        if (name != null && name.length() > 0 && !name.startsWith("xmlns:")) {
            this.appendMetadataItem(metadataItemList, name, value);
        } else {
            AnnotationLoggerProvider logger = AnnotationLogger.getInstance();
            MessageResourceProvider mess = MessageResources.getInstance();
            String message = mess.getServerLocaleResMessage(AnnotationI18NCode.EMPTY_METADATAITEM_NOT_STORED, new Object[]{name});
            logger.logRuntimeWarning(message, null, null, null, null);
        }
    }

    private void appendMetadataItem(List<MetadataItem> metadataItemList, String name, String value) {
        MetadataItem metadataItem = new MetadataItem(name, value);
        metadataItemList.add(metadataItem);
    }
}

