/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.deserialize;

import com.ibm.cognos.internal.annotations.convert.deserialize.Deserializer;
import com.ibm.cognos.internal.annotations.convert.deserialize.DeserializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.i18n.AnnotationI18NCode;
import com.ibm.cognos.internal.annotations.i18n.MessageResourceProvider;
import com.ibm.cognos.internal.annotations.i18n.MessageResources;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.service.AnnotationLogger;
import com.ibm.cognos.internal.annotations.service.AnnotationLoggerProvider;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class DimensionMemberDeserializer
implements Deserializer {
    private Node selectionDimensionMember;
    private DeserializerFactory factory;

    public DimensionMemberDeserializer(Node selectionDimensionMember, DeserializerFactory factory) {
        this.selectionDimensionMember = selectionDimensionMember;
        this.factory = factory;
    }

    @Override
    public Object convert() throws AnnotationServiceException {
        ArrayList<DataItem> dataItemList = new ArrayList<DataItem>();
        List dimensionMemberElements = this.selectionDimensionMember.selectNodes("./*");
        if (dimensionMemberElements != null) {
            for (Node node : dimensionMemberElements) {
                if (!(node instanceof Element)) continue;
                this.appendDataItem(dataItemList, node);
            }
        }
        DimensionMember dimensionMember = new DimensionMember();
        dimensionMember.getDataItems().addAll(dataItemList);
        return dimensionMember;
    }

    private void appendDataItem(List<DataItem> dataItemList, Node node) {
        String name = node.getName();
        String value = node.getText();
        if (name != null && name.length() > 0 && !name.startsWith("xmlns:")) {
            DataItem dataItem = new DataItem(name, value);
            dataItemList.add(dataItem);
        } else {
            AnnotationLoggerProvider logger = AnnotationLogger.getInstance();
            MessageResourceProvider mess = MessageResources.getInstance();
            String message = mess.getServerLocaleResMessage(AnnotationI18NCode.EMPTY_DATAITEM_NOT_STORED, new Object[]{name});
            logger.logRuntimeWarning(message, null, null, null, null);
        }
    }
}

