/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.serialize;

import com.ibm.cognos.internal.annotations.convert.serialize.Serializer;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerContext;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.annotations.pojos.AnnotationProperty;
import com.ibm.cognos.internal.annotations.service.XMLSOAPHelper;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import java.util.Locale;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultCDATA;

public class AnnotationSerializer
implements Serializer {
    private SerializerFactory factory;
    private Annotation annotation;
    private SerializerContext context;

    public AnnotationSerializer(Annotation annotation, SerializerContext context, SerializerFactory factory) {
        this.annotation = annotation;
        this.factory = factory;
        this.context = context;
    }

    @Override
    public Element convert() throws AnnotationServiceException {
        Document document = DocumentHelper.createDocument();
        Element annotationElement = document.addElement(XMLSOAPHelper.ANNOTATION_ELEMENT);
        Element idElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_ID);
        idElement.addText("" + this.annotation.getId());
        Element parentIdElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_PARENTID);
        if (this.annotation.getParentId() != null) {
            parentIdElement.addText(this.annotation.getParentId());
        }
        if (this.annotation.getSecondaryParentId() != null) {
            Element secondaryParentIdElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_SECONDARY_PARENTID);
            secondaryParentIdElement.addText(this.annotation.getSecondaryParentId());
        }
        Element localeElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_LOCALE);
        localeElement.addText(this.annotation.getLocale().toString());
        Element nameElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_NAME);
        if (this.annotation.getText().getName() != null) {
            nameElement.addText(this.annotation.getText().getName());
        }
        Element descriptionElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_DESCRIPTION);
        if (this.annotation.getText().getDescription() != null) {
            descriptionElement.addText(this.annotation.getText().getDescription());
        }
        Element creationTimeElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_CREATIONTIME);
        creationTimeElement.addText(XMLSOAPHelper.dateTimeFormat.format(this.annotation.getCreationTime()));
        Element lastModificationTimeElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_LASTMODTIME);
        lastModificationTimeElement.addText(XMLSOAPHelper.dateTimeFormat.format(this.annotation.getLastModificationTime()));
        Element ownerElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_OWNER);
        if (this.annotation.getOwner() != null) {
            ownerElement.addText(this.annotation.getOwner());
        }
        if (this.annotation.getContext() != null) {
            Element contextElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_CONTEXT);
            Serializer contextBuilder = this.factory.getSerializer(this.annotation.getContext(), this.context);
            contextElement.add(contextBuilder.convert());
        }
        String creationTimeFormatted = TimeUtils.getUserTZFormattedTime((Long)this.annotation.getCreationTime().getTime(), this.context.getTimeZone(), new Locale(this.context.getContentLocale()));
        String lastModTimeFormatted = TimeUtils.getUserTZFormattedTime((Long)this.annotation.getLastModificationTime().getTime(), this.context.getTimeZone(), new Locale(this.context.getContentLocale()));
        Element creationTimeFormattedElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_CREATIONTIMEFORMATTED);
        creationTimeFormattedElement.setText(creationTimeFormatted);
        Element lastModTimeFormattedElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_LASTMODTIMEFORMATTED);
        lastModTimeFormattedElement.setText(lastModTimeFormatted);
        if (this.annotation.getProperties() != null && this.annotation.getProperties().size() > 0) {
            Element annotationTagsElement = annotationElement.addElement(XMLSOAPHelper.ANNOTATION_TAGS);
            for (AnnotationProperty property : this.annotation.getProperties()) {
                Element annotationTagElement = annotationTagsElement.addElement(XMLSOAPHelper.ANNOTATION_TAG);
                Element tagNameElement = annotationTagElement.addElement(XMLSOAPHelper.ANNOTATION_TAG_NAME);
                tagNameElement.setText(property.getName());
                Element tagValueElement = annotationTagElement.addElement(XMLSOAPHelper.ANNOTATION_TAG_VALUE);
                DefaultCDATA cdata = new DefaultCDATA(property.getValue());
                tagValueElement.add((CDATA)cdata);
            }
        }
        annotationElement.detach();
        return annotationElement;
    }
}

