/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.annotations.convert.serialize;

import com.ibm.cognos.internal.annotations.convert.serialize.Serializer;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerContext;
import com.ibm.cognos.internal.annotations.convert.serialize.SerializerFactory;
import com.ibm.cognos.internal.annotations.exceptions.AnnotationServiceException;
import com.ibm.cognos.internal.annotations.pojos.Context;
import com.ibm.cognos.internal.annotations.pojos.DataItem;
import com.ibm.cognos.internal.annotations.pojos.DimensionMember;
import com.ibm.cognos.internal.annotations.pojos.MetadataItem;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ContextSerializer
implements Serializer {
    private SerializerFactory factory;
    private Context context;
    private SerializerContext serializerContext;

    public ContextSerializer(Context context, SerializerContext serializerContext, SerializerFactory factory) {
        this.context = context;
        this.factory = factory;
        this.serializerContext = serializerContext;
    }

    @Override
    public Element convert() throws AnnotationServiceException {
        Element selectionsElement = null;
        selectionsElement = this.oldConvert();
        return selectionsElement;
    }

    private Element oldConvert() throws AnnotationServiceException {
        Hashtable builtDimensionMembers = new Hashtable();
        ArrayList<DimensionMember> elementDimensionMembers = new ArrayList<DimensionMember>();
        for (DimensionMember dimensionMember : this.context.getDimensionMembers()) {
            if (this.isElementDimension(dimensionMember)) {
                elementDimensionMembers.add(dimensionMember);
                continue;
            }
            Serializer dimensionMemberBuilder = this.factory.getSerializer(dimensionMember, this.serializerContext);
            Element dimMemberElement = dimensionMemberBuilder.convert();
            if (!builtDimensionMembers.containsKey(dimMemberElement.getName())) {
                builtDimensionMembers.put(dimMemberElement.getName(), new ArrayList());
            }
            ((List)builtDimensionMembers.get(dimMemberElement.getName())).add(dimMemberElement);
        }
        Document document = DocumentHelper.createDocument();
        Element selectionsElement = document.addElement("selections");
        Element queryElement = selectionsElement.addElement("query");
        if (elementDimensionMembers != null) {
            this.fillQueryNameAttribute(queryElement, elementDimensionMembers);
        }
        Element selectionElement = queryElement.addElement("selection");
        Element rowsElement = selectionElement.addElement("rows");
        if (builtDimensionMembers.containsKey("row")) {
            this.addDimensionMembers(rowsElement, (List)builtDimensionMembers.get("row"));
        }
        Element columnsElement = selectionElement.addElement("columns");
        if (builtDimensionMembers.containsKey("column")) {
            this.addDimensionMembers(columnsElement, (List)builtDimensionMembers.get("column"));
        }
        Element measuresElement = selectionElement.addElement("measures");
        if (builtDimensionMembers.containsKey("measure")) {
            this.addDimensionMembers(measuresElement, (List)builtDimensionMembers.get("measure"));
        }
        Element sectionsElement = selectionElement.addElement("sections");
        if (builtDimensionMembers.containsKey("section")) {
            this.addDimensionMembers(sectionsElement, (List)builtDimensionMembers.get("section"));
        }
        Element layoutIDElement = selectionElement.addElement("layoutElementId");
        if (elementDimensionMembers != null) {
            this.fillLayoutElementId(layoutIDElement, elementDimensionMembers);
        }
        Element burstContextElement = selectionsElement.addElement("burst-context");
        return selectionsElement;
    }

    private boolean isElementDimension(DimensionMember dimensionMember) {
        boolean ret_value = false;
        List<DataItem> dimensionDataItems = dimensionMember.getDataItems();
        List<MetadataItem> metadataItems = dimensionMember.getDimension().getMetadataItems();
        if (dimensionDataItems.size() == 1 && dimensionDataItems.get(0).getName().startsWith("#") && metadataItems.size() == 1 && metadataItems.get(0).getName().startsWith("#")) {
            ret_value = true;
        }
        return ret_value;
    }

    private void fillLayoutElementId(Element layoutElement, List<DimensionMember> elementDimensionMembers) {
        for (DimensionMember dimensionMember : elementDimensionMembers) {
            if (!dimensionMember.getDimension().getMetadataItems().get(0).getValue().equals("layoutElementId")) continue;
            layoutElement.addText(dimensionMember.getDataItems().get(0).getValue());
            break;
        }
    }

    private void fillQueryNameAttribute(Element queryElement, List<DimensionMember> elementDimensionMembers) {
        for (DimensionMember dimensionMember : elementDimensionMembers) {
            if (!dimensionMember.getDimension().getMetadataItems().get(0).getValue().equals("name")) continue;
            queryElement.addAttribute("name", dimensionMember.getDataItems().get(0).getValue());
            break;
        }
    }

    private void addDimensionMembers(Element parentElement, List<Element> childElements) {
        for (Element element : childElements) {
            parentElement.add(element);
        }
    }
}

